/*
 * ReaderEyeTrackerResults.cpp
 *
 *  Created on: Jun 6, 2013
 *      Author: vincent
 *
 *  Modified on : April 20, 2015
 *      Author: Souad
 *
 ***********Tobii****************
 *  Modified on : summer, 2015
 *  Author: Mariem CHEIKH ROUHOU
 ***********Tobii****************
 */

#include "ReaderEyeTrackerResults.hpp"
#include "spline.h"//pour l'interpolation
#include <math.h>       /* sqrt ; acos */
#include <stdlib.h>     /* abs */
#include <algorithm>    /* max */

#define PI 3.14159265
#define ImResHor 1080 /*resolution horizontal de la caméra*/
#define ImResVert 1920 /*resolution vertical de la caméra*/
#define alpha 2  /*projection de la fovéa 2°*/
#define beta 24  /*l'angle en x d'ouverture de la caméra*/
#define A 1600 /*ponderation de la largeur de la carte de saillance en fonction de la distance*/
#define epsilon 0.3//seuil : intersection entre deux vecteurs 10%


ReaderEyeTrackerResults::ReaderEyeTrackerResults():
m_resultFile(),
m_fps(),
m_videoWidth(),
m_videoHeight()
{}

//constructeur
ReaderEyeTrackerResults::ReaderEyeTrackerResults(const char * fileResults,double fps, int videoWidth, int videoHeight):
  m_resultFile(fileResults),
  m_fps(fps),
  m_videoWidth(videoWidth),
  m_videoHeight(videoHeight)
{}

//destructeur
ReaderEyeTrackerResults::~ReaderEyeTrackerResults() {}

//Lire mot à partir de la postion et d'un ligne
std::string
ReaderEyeTrackerResults::readWord(int wordPosition, std::string line)
{
	std::string currentWord;
	std::string::iterator it;

	int count=0;
	int pos=0;
	int length=1;
	int beginWord=0;
      	int size=line.size();
	for (it= line.begin(); it != line.end(); it++)
	{
		if ((*it) == ',')
		(*it)='.';
		if ((*it) == '\t')
		{
			currentWord=line.substr(beginWord, length-1);
			beginWord=pos+1;
			length=0;
			count++;
		}
		pos++;
		length++;

		if(count == wordPosition || pos >= size)

			break;
	}

	//std::cout << "returned Word:" << currentWord << std::endl;
return currentWord;
}


//return coordonnees
std::vector< std::pair<double,double> >
ReaderEyeTrackerResults::readResultsNewFrame()
{

	std::vector< std::pair<double,double> > coordinates;
	std::vector< std::pair<double,double> > coordinates_interpo_frame;
	std::vector<double> time;
	int Recording_duration;

	int numline=1;
	int firstline=0;
	if (m_resultFile.is_open())
	{
		while (m_resultFile.good())
		{			
			while(std::getline(m_resultFile,m_lineRes))//cette boucle s'arrête dès qu'une erreur de lecture survien  
									  //(m_lineRes : variable contenant chaque ligne lue) 
			{

				if (firstline >= numline)
				{
				Recording_duration=(int)(atoi(this->readWord(RECORDING_DURATION, m_lineRes).c_str()));
					
				double GP_X = (double)(atof(this->readWord(HORIZONTAL_POSITION, m_lineRes).c_str()));
				double GP_Y = (double)(atof(this->readWord(VERTICAL_POSITION, m_lineRes).c_str()));	
				const std::pair<double,double> coord_aux(GP_X,GP_Y);
				coordinates.push_back(coord_aux);			
			  	
				//extraire time stamp pour l'interpolation
				double t = (double)(atof(this->readWord(TIMESTAMP_POSITION, m_lineRes).c_str()));
				time.push_back(t);
				
				}
				firstline++;
			}

			std::cout <<"Recording duration : "<<Recording_duration<<std::endl;
			std::cout <<"NB lines in the file : "<<coordinates.size()<<std::endl;

			coordinates_interpo_frame = this->interpolationFrame (time,coordinates,Recording_duration);						
		}
	}

return coordinates_interpo_frame;
}



//Fonction interpolation pour frame 40
std::vector< std::pair<double,double> >
ReaderEyeTrackerResults::interpolationFrame (std::vector<double> time, std::vector< std::pair<double,double> > coordinates , int Recording_duration)
{
	int nbligne = coordinates.size();
	std::vector<double> XX,TT,YY;
	std::vector<double> temps_mul_frame;

	int temps_mul_frame_size = Recording_duration/40;//(40=(1/fps)*1000)
	std::vector< std::pair<double,double> > coordinates_interpol_frame (temps_mul_frame_size+1);
 	
	int n=0;
	for (int j=0;j<=temps_mul_frame_size;j++)
	{
	temps_mul_frame.push_back(n);
	n=n+40;
	}

	//std::vector< std::pair<double,double> > coordinates_interpol_frame(temps_mul_frame_size+1);
	/*
	for (int j=0;j<=temps_mul_frame_size;j++)
	std::cout<<temps_mul_frame[j]<<std::endl;
	*/

	std::cout<<"NB frames result : "<<temps_mul_frame.size()<<std::endl;

    
	for (int i=0; i < nbligne; i++)
	{
          if (coordinates[i].first !=0) 
            {
            XX.push_back(coordinates[i].first);
	    YY.push_back(coordinates[i].second);
            TT.push_back(time [i]);
            }        
	}

	tk::spline s1;
	tk::spline s2;
	s1.set_points(TT,XX);//tracer un courbe (t,x)avec les point complet du fichier d'enregistrement de Tobii
 	s2.set_points(TT,YY);//tracer un courbe (t,y) avec les point complet du fichier d'enregistrement de Tobii
    
	for (int i=0; i <=temps_mul_frame_size; i++)
	{		
		coordinates_interpol_frame[i].first= s1(temps_mul_frame[i]);
		coordinates_interpol_frame[i].second= s2(temps_mul_frame[i]);
	}

	/*for (int i=0; i <=temps_mul_frame_size; i++)
	//for (int i=0; i <20 ; i++)
	{
	printf("spline (%f, %f , %f)\n", temps_mul_frame[i], coordinates_interpol_frame[i].first,coordinates_interpol_frame[i].second);
	}
	*/
	
	
return coordinates_interpol_frame;
}

//calcul de la distance entre le sujet et le cible et calcul parametre Gaussian : sigma 
std::vector<double>
ReaderEyeTrackerResults::calculSigma ()
{
	int Recording_duration;
	std::vector<double> distance_cible;
	
	//Sigma_pixel_initial constante ~= 42
	double Sigma_pixel_initial = ImResHor/2 * tan (alpha * PI / 180.0) /tan (beta * PI / 180.0);
	
	std::vector<double> y_fixation_right;
	std::vector<double> y_fixation_left;

	std::vector<double> x_fixation;
	std::vector<double> y_fixation;
	std::vector<double> z_fixation;

	std::vector<double> sigma;
	std::vector<double> time;

	std::vector<double> time_sigma_interpo;
		
	int numline=1;
	int firstline=0;
	std::vector<double> pupil_pos_l_x;

	if (m_resultFile.is_open())
	{

		while (m_resultFile.good())
		{
			
			while(std::getline(m_resultFile,m_lineRes))//cette boucle s'arrête dès qu'une erreur de lecture survien  
								   //(m_lineRes : variable contenant chaque ligne lue) 
			{
				Recording_duration=(int)(atoi(this->readWord(RECORDING_DURATION, m_lineRes).c_str()));

				if (firstline >= numline)
				{

					if  (((double)(atof(this->readWord(PUPIL_DIAMETER_LEFT, m_lineRes).c_str()))!=0 ) && ((double)(atof(this->readWord(PUPIL_DIAMETER_RIGHT, m_lineRes).c_str()))  
					!=0))//filtrage que les lignes avec tout les coordonnees complet
					{
					double Pupil_pos_l_x = (double)(atof(this->readWord(PUPIL_POSITION_LEFT_X, m_lineRes).c_str()));
					double Pupil_pos_l_y = (double)(atof(this->readWord(PUPIL_POSITION_LEFT_Y, m_lineRes).c_str()));
					double Pupil_pos_l_z = (double)(atof(this->readWord(PUPIL_POSITION_LEFT_Z, m_lineRes).c_str()));
					
					double Pupil_pos_r_x = (double)(atof(this->readWord(PUPIL_POSITION_RIGHT_X, m_lineRes).c_str()));
					double Pupil_pos_r_y = (double)(atof(this->readWord(PUPIL_POSITION_RIGHT_Y, m_lineRes).c_str()));
					double Pupil_pos_r_z = (double)(atof(this->readWord(PUPIL_POSITION_RIGHT_Z, m_lineRes).c_str()));
					
					double GD_left_x = (double)(atof(this->readWord(GAZE_DIRECTION_LEFT_X, m_lineRes).c_str()));
					double GD_left_y = (double)(atof(this->readWord(GAZE_DIRECTION_LEFT_Y, m_lineRes).c_str()));
					double GD_left_z = (double)(atof(this->readWord(GAZE_DIRECTION_LEFT_Z, m_lineRes).c_str()));

					double GD_right_x = (double)(atof(this->readWord(GAZE_DIRECTION_RIGHT_X, m_lineRes).c_str()));
					double GD_right_y = (double)(atof(this->readWord(GAZE_DIRECTION_RIGHT_Y, m_lineRes).c_str()));
					double GD_right_z = (double)(atof(this->readWord(GAZE_DIRECTION_RIGHT_Z, m_lineRes).c_str()));
				
					//calcul det
					double det = GD_left_z * GD_right_x - GD_left_x *GD_right_z;
					
						//verifier que la matrice est inversible det!=0 
						if (det!=0)
						{
							
						//t_left et t_right parametre des deux droite
						double t_left = (-GD_right_z * (Pupil_pos_r_x -Pupil_pos_l_x)+GD_right_x*(Pupil_pos_r_z -Pupil_pos_l_z))/det;
						double t_right = (-GD_left_z * (Pupil_pos_r_x -Pupil_pos_l_x)+GD_left_x*(Pupil_pos_r_z -Pupil_pos_l_z))/det;
				
						//verification des parametre dans 3 eme equation
						double Y_fixation_left = Pupil_pos_r_y + t_right * GD_right_y;
						//y_fixation_left.push_back ( Y_fixation_left);
						double Y_fixation_right = Pupil_pos_r_y + t_right * GD_right_y;
						//y_fixation_right.push_back (Y_fixation_right);

							//seuil appliquer sur Y_fixation_left et Y_fixation_right
							if ((abs(Y_fixation_right-Y_fixation_left)/std::max(Y_fixation_right,Y_fixation_left)) >= (-epsilon) && (abs(Y_fixation_right-Y_fixation_left)/std::max(Y_fixation_right,Y_fixation_left)) <= epsilon)
							{
							//point de fixation de coordonnees X_fixation Z_fixation et Y_fixation
							double X_fixation = Pupil_pos_l_x + t_left * GD_left_x;
							x_fixation.push_back (X_fixation);
							double Z_fixation = Pupil_pos_l_z + t_left * GD_left_z;
							z_fixation.push_back (Z_fixation);
							double Y_fixation = Pupil_pos_l_y + t_left * GD_left_y;
							y_fixation.push_back (Y_fixation);

							//calcul de la distance entre le sujet et le cible
							double Distance_cible = claculDistanceEspace(0,X_fixation,0,Y_fixation,0,Z_fixation);
							//distance_cible.push_back (Distance_cible);
						
							//extraire time stamp pour l'interpolation
							double t = (double)(atof(this->readWord(TIMESTAMP_POSITION, m_lineRes).c_str()));
							time.push_back(t);

							// calcul parametre Gaussian : sigma 
							double Sigma_pixel = Sigma_pixel_initial * A /(Distance_cible + 0.00001);
							sigma.push_back(Sigma_pixel);				
							}
						}						
					}
				}
				firstline++;

			}

			time_sigma_interpo = this->interpolationSigma (time, sigma ,Recording_duration);	
		}


	}

	//affichage
	
	/*for (int i=0; i <y_fixation_left.size() ; i++)
	{
	printf("(%d, %f , %f ) \n",i,y_fixation_left[i],y_fixation_right[i]);
	}*/

	/*for (int i=0; i <x_fixation.size() ; i++)
	{
	printf("Point de fixation (%f , %f , %f ) \n" ,x_fixation[i],y_fixation[i],z_fixation[i]);
	}*/

	/*for (int i=0; i <distance_cible.size() ; i++)
	{
	printf("%f \n",distance_cible [i]);
	}*/
	
	/*for (int i=0; i <time.size() ; i++)
	{
	printf("%d \n" ,int (time [i]));
	}*/
	
	/*for (int i=0; i <sigma.size(); i++)
	{
	printf("%f\n",sigma [i]);
	}*/

	return time_sigma_interpo;


}

//calcul de la distance entre deux points dans l'espace
double 
ReaderEyeTrackerResults::claculDistanceEspace(double x1,double x2, double y1, double y2,double z1 ,double z2)
{
return (sqrt ((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)+(z2-z1)*(z2-z1)));
}


//Fonction interpolation sigma frame 40
std::vector<double>
ReaderEyeTrackerResults::interpolationSigma (std::vector<double> time, std::vector<double> sigma , int Recording_duration)
{
	
	std::vector<double> time_mul_frame;
	int time_mul_frame_size = Recording_duration/40;//(40=(1/fps)*1000)
 	
	std::vector<double> sigma_interpo (time_mul_frame_size+1);

	int n=0;
	for (int j=0;j<=time_mul_frame_size;j++)
	{
	time_mul_frame.push_back(n);
	n=n+40;
	}

	
	//std::vector< std::pair<double,double> > coordinates_interpol_frame(time_mul_frame_size+1);
	/*
	for (int j=0;j<=time_mul_frame_size;j++)
	std::cout<<time_mul_frame[j]<<std::endl;
	*/


	tk::spline s1;
	s1.set_points(time,sigma);//tracer un courbe (time,sigma)
 	
	for (int i=0; i <= time_mul_frame_size; i++)
	{	
		sigma_interpo [i] = s1(time_mul_frame[i]);
			if (sigma_interpo [i]<= 0)//il faut sigma soit positive
				sigma_interpo [i]= sigma_interpo [i-1];//remplacer les valeurs negative par la valeurs precedente (ou bien la moyenne des deux valeurs (avant apres))
	}
		
	/*for (int i=0; i <=time_mul_frame_size; i++)
	{
	printf("%d %f\n",i, sigma_interpo[i]);
	}*/
	
	
return sigma_interpo;
}


