#include <cstdlib>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>
#include <algorithm>

#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/gpu/gpu.hpp>
#include "ReaderEyeTrackerResults.hpp"


void usage(const char *cmd);
cv::Mat getGaussianKernelWithCenter(int length, int center, double sigma);
void wooding_compute( const char* tsvname, int fps, int width, int height, int duration, const char* outputdir, int nbFrames );

int main(int argc, char **argv)
{
	//verification des parametre d'entrees dans la ligne de commande
	if( argc != 5 )
		usage( argv[0] );

	const char* tsvname(       argv[1]  );
	const char* videoname(     argv[2]  );
	const int   duration( atoi(argv[3]) );
	const char* outputdir(     argv[4]  );

	//verification de la video
	cv::VideoCapture video( videoname );
	if( ! video.isOpened() )
	{
		std::cerr << "Erreur de lecture du fichier video: " << videoname << std::endl;
		return EXIT_FAILURE;
	}


//caracteristiques du video
	int nbFrames( video.get(CV_CAP_PROP_FRAME_COUNT)  ); // nombre de frames dans le video
	int fps(      video.get(CV_CAP_PROP_FPS)          ); // frame rate) 
	int width(    video.get(CV_CAP_PROP_FRAME_WIDTH)  ); // Largeur des trames dans le flux de vidéo
	int height(   video.get(CV_CAP_PROP_FRAME_HEIGHT) ); // Hauteur des trames dans le flux de vidéo

	std::cout << "Nb Frames    : " << nbFrames << std::endl;
	std::cout << "Frame rate   : " << fps      << std::endl;
	std::cout << "Frame width  : " << width    << std::endl;
	std::cout << "Frame height : " << height   << std::endl;

	cv::Mat frame;
	const char* name = "Wooding TSV";

	while ( true )
	{
		video >> frame;
		if ( frame.cols != 0 && frame.rows != 0 )
		{
			cv::resize( frame, frame, cv::Size(800, 600) );
			cv::imshow( name, frame );
		}
		else std::cout << "nope" << std::endl;

		if ( cv::waitKey(1) == 'q' )
			break;
	}

	video.release();

	// wooding_compute( tsvname, fps, width, height, duration, outputdir, nbFrames );

	return EXIT_SUCCESS;
}

//Les fonctions

//fonction pour la verification de la ligne de commande
void usage( const char* cmd )
{
	std::cerr << "Usage: " << cmd << " <EyeTracker-file> <input_video> <greyDuration(frames)> <output_folder>" << std::endl;
	exit( EXIT_FAILURE );
}


//appliquer le filtre Gaussian
cv::Mat getGaussianKernelWithCenter( int length, int center, double sigma )
{
	cv::Mat auxKernel( cv::getGaussianKernel( length*3, sigma, CV_32F ) );
	cv::Mat gaussianKernel( auxKernel.rowRange( length + (length/2-center), 2*length + (length/2-center) ) );
	return gaussianKernel;
}

//Wooding_Compute
void wooding_compute( const char* argv_1, int fps, int width, int height, int argv_3, const char* argv_4, int nbFrames )
{
	cv::Mat mix;
	double minVal; 
	double maxVal; 
	cv::Point minLoc;
	cv::Point maxLoc;

	std::string extension = ".png";
	std::string title;
	
	int stepProgressDisplay=100;

	// initialise result_files
	std::vector<ReaderEyeTrackerResults*> resultFiles;
	std::vector<ReaderEyeTrackerResults*> resultFiles2;
	
	ReaderEyeTrackerResults* resultFile = new ReaderEyeTrackerResults( argv_1, fps, width, height, argv_3 );

	
	//Gaussian parameters
	std::vector<double> sigma( resultFile->calculSigma() );

	//cv::Mat trame;

	// Read eye positions 40
	std::vector< std::pair<double,double> > coordinates = resultFile->readResultsNewFrame();
	int coordinates_size = coordinates.size();
	std::cout << nbFrames - coordinates_size << " Frame noire car la langueur du video float (avec ,) et le temps dans le fichier d'enregistrement int" << std::endl;

	for ( int currentProcessedFrames( 1 ) ; currentProcessedFrames <= argv_3 ; ++currentProcessedFrames ) 
	{
		//video >> trame;
		cv::Mat kernelX;
		cv::Mat kernelY;
		cv::Mat kernelXY = cv::Mat::zeros( height, width, CV_32F );//Matrice de taille height*width avec des zero (noir)

		cv::gpu::GpuMat kernelY_gpu_trans,kernelY_gpu,kernelX_gpu,kernelXY_gpu;
		cv::Mat kernelY_trans;

		if ( currentProcessedFrames < coordinates_size)
		{
			cv::Point coord( coordinates[currentProcessedFrames].first, coordinates[currentProcessedFrames].second );
			
			kernelX = getGaussianKernelWithCenter( height, coordinates[currentProcessedFrames].second, sigma[currentProcessedFrames] );
			kernelY = getGaussianKernelWithCenter( width,  coordinates[currentProcessedFrames].first,  sigma[currentProcessedFrames] );

			//GPU
			kernelY_gpu.upload( kernelY );
			cv::gpu::transpose( kernelY_gpu, kernelY_gpu_trans );//kernelY.t()					
			kernelY_gpu_trans.download( kernelY_trans );


			//old
			//kernelXY = kernelX * kernelY.t();
			kernelXY = kernelX * kernelY_trans;

			cv::circle( kernelXY, coord, 10, cv::Scalar(0x0,0x0,0xff) );//dessiner une cercle

		}

		//GPU
		kernelXY_gpu.upload( kernelXY );

		//old
		//minMaxLoc( kernelXY, &minVal, &maxVal, &minLoc, &maxLoc, cv::Mat());//Finds the global minimum and maximum in an array
		//GPU
		cv::gpu::minMaxLoc( kernelXY_gpu, &minVal, &maxVal, &minLoc, &maxLoc, cv::gpu::GpuMat() );//Finds the global minimum and maximum in an array

		//old
		//kernelXY=kernelXY *(1/maxVal) *255;
		//kernelXY.convertTo(kernelXY,CV_8U);
		//GPU
		kernelXY_gpu.convertTo( kernelXY_gpu, kernelXY_gpu.type(),(255/maxVal) ); // kernelXY_gpu=kernelXY_gpu *(1/maxVal) *255;
		kernelXY_gpu.convertTo( kernelXY_gpu, CV_8U );


		//cv::applyColorMap(kernelXY, kernelXY, cv::COLORMAP_JET);
		
		// old code
		//mix = kernelXY;
		//GPU
		kernelXY_gpu.download( mix );// download kernelXY_gpu to mix

		//cv::imshow("points", atom_image);

		//save saliency file
		std::ostringstream count_str;
		count_str << "/" << std::setw(8) << std::setfill('0') << currentProcessedFrames;
		title = argv_4+count_str.str()+extension;

		cv::imwrite( title, mix );
		

		// Show Progress
		std::cout << currentProcessedFrames << "/" <<  nbFrames << std::endl;
		
		
		//cv::imshow("mix", mix);
		//cv::imshow("trame", trame);
		//cv::imshow("gauss", kernelXY);
		//cv::waitKey(0);
	}

	std::cout << "Finished creating files in " << argv_4 << std::endl;


}


