/*
 * ReaderEyeTrackerResults.hpp
 *
 *  Created on: Jun 6, 2013
 *      Author: vincent
 *
 *  Modified on : April 20, 2015
 *      Author: Souad
 ***********Tobii**************
 *  Modified on : summer, 2015
 *      Author: Mariem
 ***********Tobii**************
 */

#ifndef READEREYETRACKERRESULTS_HPP_
#define READEREYETRACKERRESULTS_HPP_

#include <string.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <vector>
#include <utility>
#include <stdio.h>
#include <stdlib.h>

//#define PRECISION_EYETRACKER 34////enregistrement chaque 34 ms (33.33 ms)
#define TIMESTAMP_POSITION 7 //Recording timestamp
#define HORIZONTAL_POSITION 8 //Gaze point x
#define VERTICAL_POSITION 9 //Gaze point Y
#define RECORDING_DURATION 6 //Recording duration




//Gaze direction left
#define GAZE_DIRECTION_LEFT_X 10
#define GAZE_DIRECTION_LEFT_Y 11
#define GAZE_DIRECTION_LEFT_Z 12
//Gaze direction right
#define GAZE_DIRECTION_RIGHT_X 13
#define GAZE_DIRECTION_RIGHT_Y 14
#define GAZE_DIRECTION_RIGHT_Z 15

//Pupil position left
#define PUPIL_POSITION_LEFT_X 16
#define PUPIL_POSITION_LEFT_Y 17
#define PUPIL_POSITION_LEFT_Z 18
//Pupil position right
#define PUPIL_POSITION_RIGHT_X 19
#define PUPIL_POSITION_RIGHT_Y 20 
#define PUPIL_POSITION_RIGHT_Z 21

/*tester l'existance des valeurs dans le fichier*/
//Pupil diameter
#define PUPIL_DIAMETER_LEFT 22
#define PUPIL_DIAMETER_RIGHT 23

//#define EYE_MOUVMENT_TYPE 24//Fixation || EyesNotFound

class ReaderEyeTrackerResults {
public:
	ReaderEyeTrackerResults();
	ReaderEyeTrackerResults(const char * fileResults,double fps, int videoWidth, int videoHeight, int greyDuration);
	
	virtual ~ReaderEyeTrackerResults();

	//void read_m_resultFile();
	std::vector< std::pair<double,double> > readResultsNewFrame();

private:
	std::string readWord(int wordPosition, std::string line);

private:
	std::vector< std::pair<double,double> > interpolationFile (std::vector<double> time, std::vector< std::pair<double,double> > coordinates);

private:
	std::vector< std::pair<double,double> > interpolationFrame (std::vector<double> time, std::vector< std::pair<double,double> > coordinates , int Recording_duration);

public:
	std::vector<double> calculSigma ();

public:
	std::vector<double> interpolationSigma (std::vector<double> time, std::vector<double> sigma , int Recording_duration);
			    
private:
	double claculDistanceEspace(double x1,double x2, double y1, double y2,double z1 ,double z2);

private:
	std::ifstream m_resultFile;
	double m_fps;
	int m_videoWidth;
	int m_videoHeight;
	int m_screenWidthPx;
	int m_screenHeightPx;
	int m_screenWidthmm;
	int m_screenHeightmm;
	int m_greyDuration;
	//std::string m_stateRequired;
	//std::string m_currentState;
	std::string m_lineRes;
};

#endif /* READEREYETRACKERRESULTS_HPP_ */
