// ##################################################
// ###              TOBII_SERVER_HPP              ###
// ##################################################
#ifndef TOBII_SERVER_HPP
#define TOBII_SERVER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Device/Device.hpp"
#include "TobiiSDK/Server/Recorder.hpp"

// EXTERNAL LIBRARIES
#include <QObject>
#include <QMutex>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS TOBIISDK              ###
	// ##################################################
	
	class TobiiSDK : public Recorder
	{
		Q_OBJECT
	private:
		DevicePtr 		_ptrDevice;
		QMutex			_mutex;
		FramePtr		_ptrFrame;
		GazeFixationPtr	_ptrFixation;
		AccelerationPtr	_ptrAcceleration;
		OrientationPtr	_ptrOrientation;
		bool			_sdkFinished;

	public:
		TobiiSDK ( Int64 windowSize = 2000, bool keepAllPackets = false, bool forceInterpolation = true, bool forceComputingDistance = false, DevicePtr ptrDevice = DevicePtr(), QObject* parent = NULL );
		virtual ~TobiiSDK ();

		void connectSlots ();
		
		const DevicePtr& 		ptrDevice		() const;
		DevicePtr&		 		ptrDevice		();
		const cv::Size&			resolution		() const;
		cv::Size&				resolution		();
		const QMutex&			mutex			() const;
		QMutex&					mutex			();
		bool					hasFinished		() const;
		bool&					hasFinished		();
		const FramePtr&			ptrFrame		() const;
		FramePtr&				ptrFrame		();
		const GazeFixationPtr&	ptrFixation		() const;
		GazeFixationPtr&		ptrFixation		();
		const AccelerationPtr&	ptrAcceleration	() const;
		AccelerationPtr&		ptrAcceleration	();
		const OrientationPtr&	ptrOrientation	() const;
		OrientationPtr&			ptrOrientation	();
		
	private slots:
		void deviceFinished ();

	public slots:
		void setPtrDevice	( DevicePtr ptrDevice );
		void startReading	( const QString& arg1 = "", const QString& arg2 = "" );
		void finishReading	();
		void stop			();

		virtual void receiveAcceleration ( AccelerationPtr ptrAcceleration );
		virtual void receiveOrientation  ( OrientationPtr  ptrOrientation );
		virtual void receiveSynkedData	 ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );
		virtual void readingFinished	 ();
	
	signals:
		void finished ();

	private:
		TobiiSDK ( const TobiiSDK& device ) = delete;
		TobiiSDK& operator= ( const TobiiSDK& device ) = delete;

	}; // END CLASS SERVER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_SERVER_HPP
// ##################################################
