// ##################################################
// ###          TOBII_VIDEOHEADER_HPP             ###
// ##################################################
#ifndef TOBII_VIDEOHEADER_HPP
#define TOBII_VIDEOHEADER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES:
#include <QString>
#include <QDebug>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###            CLASS VIDEO-HEADER              ###
	// ##################################################

	class VideoHeader
	{
	private:
		cv::Size	_resolution;
		int			_fps;
		int			_frameCount;
		double		_format;

	public:
		VideoHeader ( const cv::Size& resolution = cv::Size(0, 0), int fps = 0, int frameCount = 0, double format = CV_8UC3 );
		VideoHeader ( const VideoHeader& header );

		const cv::Size&		resolution	() const;
		cv::Size&			resolution	();
		int					fps			() const;
		int&				fps			();
		int					frameCount	() const;
		int&				frameCount	();
		double				format		() const;
		double&				format		();

		VideoHeader& operator= ( const VideoHeader& stream );

		static VideoHeader fromVideoFile ( const QString& name );

	}; // END CLASS VIDEO-HEADER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_VIDEOHEADER_HPP
// ##################################################