// ##################################################
// ###          TOBII_VIDEOHEADER_CPP             ###
// ##################################################
#ifndef TOBII_VIDEOHEADER_CPP
#define TOBII_VIDEOHEADER_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "VideoHeader.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###            CLASS VIDEO-HEADER              ###
	// ##################################################

	VideoHeader::VideoHeader ( const cv::Size& resolution, int fps, int frameCount, double format )
	: _resolution( resolution ), _fps( fps ), _frameCount( frameCount ), _format( format )
	{}

	VideoHeader::VideoHeader ( const VideoHeader& header )
	: _resolution( header.resolution() ), _fps( header.fps() )
	, _frameCount( header.frameCount() ), _format( header.format() )
	{}

	const cv::Size&		VideoHeader::resolution	() const	{ return this->_resolution;	}
	cv::Size&			VideoHeader::resolution	()			{ return this->_resolution;	}
	int					VideoHeader::fps		() const	{ return this->_fps;		}
	int&				VideoHeader::fps		()			{ return this->_fps;		}
	int					VideoHeader::frameCount	() const	{ return this->_frameCount;	}
	int&				VideoHeader::frameCount	()			{ return this->_frameCount;	}
	double				VideoHeader::format		() const	{ return this->_format;		}
	double&				VideoHeader::format		()			{ return this->_format;		}

	VideoHeader& VideoHeader::operator= ( const VideoHeader& stream )
	{
		this->resolution()	= stream.resolution();
		this->fps()			= stream.fps();
		this->frameCount()	= stream.frameCount();
		this->format()		= stream.format();
		return (*this);
	}

	VideoHeader VideoHeader::fromVideoFile ( const QString& name )
	{
		VideoHeader result;

		cv::VideoCapture video;
		if ( video.open(name.toStdString()) )
		{
			result.resolution().width	= video.get( CV_CAP_PROP_FRAME_WIDTH	);
			result.resolution().height	= video.get( CV_CAP_PROP_FRAME_HEIGHT	); 
			result.fps()				= video.get( CV_CAP_PROP_FPS			);
			result.frameCount()			= video.get( CV_CAP_PROP_FRAME_COUNT	);
			result.format()				= video.get( CV_CAP_PROP_FORMAT			);
		}
		else
			qDebug() << "VideoHeader::fromVideoFile(const std::string&): could not read header in video file \"" << name << "\" !";
		
		return result;
	}

	// END CLASS VIDEO-HEADER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_VIDEOHEADER_CPP
// ##################################################
