// ##################################################
// ###             TOBII_STREAM_HPP               ###
// ##################################################
#ifndef TOBII_STREAM_HPP
#define TOBII_STREAM_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES: 
#include <QString>
#include <map>

// INTERNAL MODULES:
#include "TobiiSDK/Data/PrimitifTypes.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
 namespace Tobii {

	// ##################################################
	// ###               CLASS STREAM                 ###
	// ##################################################

	class Stream
	{
		// --------------------------------------------------
		// MEMBER TYPES
	public:
		// key: timeStamp, value: index
		using IndexMap   = std::map< Int64, Int64 >;

	private:
		// --------------------------------------------------
		// MEMBER VARIABLES
		QString		_name;
		IndexMap	_indexes;
		Int64		_currentTimeStamp, _currentIndex;
		
		// --------------------------------------------------
		// CONSTRUCTOR - DESTRUCTOR
	public:
		Stream ( const QString&	name = ""	);
		Stream ( const Stream&	stream		);
		virtual ~Stream ();
		Stream& operator= ( const Stream& stream );
		
		// --------------------------------------------------
		// GETTERS - SETTERS

		const QString&	name				() const;
		QString&		name				();
		const IndexMap&	indexes				() const;
		IndexMap&		indexes				();
		Int64			currentTimeStamp	() const;
		Int64&			currentTimeStamp	();
		Int64			currentIndex		() const;
		Int64&			currentIndex		();

		Int64	firstIndex		() const;
		Int64	firstTimeStamp	() const;
		Int64	lastIndex		() const;
		Int64	lastTimeStamp	() const;

		virtual Int64 getIndexAt		( Int64 timeStamp ) const;
		virtual Int64 getTimeStampAt	( Int64 index ) const;

		virtual void next ();
		virtual void previous ();

		virtual void setCurrentTimeStamp ( Int64 timeStamp );
		virtual void setCurrentIndex	 ( Int64 index );

		// --------------------------------------------------
		// OPEN - CLOSE

		virtual bool open	( const QString& name ) = 0;
		virtual bool isOpen	() const = 0;
		virtual bool close	() = 0;

		// --------------------------------------------------
		// EDIT

		virtual void addTimeStamp ( Int64 timeStamp, Int64 index = -1 );

	}; // END CLASS STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_STREAM_HPP
// ##################################################