// ##################################################
// ###             TOBII_STREAM_CPP               ###
// ##################################################
#ifndef TOBII_STREAM_CPP
#define TOBII_STREAM_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Stream.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###               CLASS STREAM                 ###
	// ##################################################

	// --------------------------------------------------
	// CONSTRUCTOR - DESTRUCTOR

	Stream::Stream ( const QString& name )
	: _name( name ), _currentTimeStamp( 0 ), _currentIndex( 0 )
	{}

	Stream::Stream ( const Stream& stream )
	: _name( stream.name() ), _currentTimeStamp( stream.currentTimeStamp() ), _currentIndex( stream.currentIndex() )
	{}

	Stream::~Stream ()
	{}

	Stream& Stream::operator=( const Stream& stream )
	{
		this->name()			 = stream.name();
		this->indexes()			 = stream.indexes();
		this->currentTimeStamp() = stream.currentTimeStamp();
		this->currentIndex()     = stream.currentIndex();
		return (*this);
	}

	// --------------------------------------------------
	// GETTERS - SETTERS

	const QString&			Stream::name				() const	{ return this->_name;				}
	QString&				Stream::name				()			{ return this->_name;				}
	const Stream::IndexMap&	Stream::indexes				() const	{ return this->_indexes;			}
	Stream::IndexMap&		Stream::indexes				()			{ return this->_indexes;			}
	Int64					Stream::currentTimeStamp	() const	{ return this->_currentTimeStamp;	}
	Int64&					Stream::currentTimeStamp	()			{ return this->_currentTimeStamp;	}
	Int64					Stream::currentIndex		() const	{ return this->_currentIndex;		}
	Int64&					Stream::currentIndex		()			{ return this->_currentIndex;		}

	Int64 Stream::firstIndex () const
	{
		if ( this->indexes().empty() )
			return -1;
		return this->indexes().begin()->second;
	}

	Int64 Stream::firstTimeStamp () const
	{
		if ( this->indexes().empty() )
			return -1;
		return this->indexes().begin()->first;
	}

	Int64 Stream::lastIndex	 () const
	{
		if ( this->indexes().empty() )
			return -1;
		return (--this->indexes().end())->second;
	}

	Int64 Stream::lastTimeStamp () const
	{
		if ( this->indexes().empty() )
			return -1;
		return (--this->indexes().end())->first;
	}

	Int64 Stream::getIndexAt ( Int64 timeStamp ) const
	{
		if ( this->indexes().find(timeStamp) != this->indexes().end() )
			return this->indexes().at(timeStamp);

		return -1;
	}
	
	Int64 Stream::getTimeStampAt ( Int64 index ) const
	{
		for ( auto& it : this->indexes() )
		{
			if ( it.second == index )
				return it.first;
		}
		return -1;
	}

	void Stream::next ()
	{
		this->currentTimeStamp() += 40;
		this->currentIndex()     += 1;
	}

	void Stream::previous ()
	{
		this->currentTimeStamp() -= 40;
		this->currentIndex()     -= 1;
	}

	void Stream::setCurrentTimeStamp ( Int64 timeStamp )
	{
		this->currentTimeStamp() = timeStamp;
		this->currentIndex() = this->getIndexAt( timeStamp );
	}

	void Stream::setCurrentIndex ( Int64 index )
	{
		this->currentIndex() = index;
		this->currentTimeStamp() = this->getTimeStampAt( index );
	}

	// --------------------------------------------------
	// EDIT

	void Stream::addTimeStamp ( Int64 timeStamp, Int64 index )
	{
		this->indexes().emplace(
			timeStamp,
			(index == -1 ? this->indexes().size() : index)
		);
	}

	// END CLASS STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_STREAM_HPP
// ##################################################