// ##################################################
// ###        TOBII_OUTPUTVIDEOSTREAM_CPP         ###
// ##################################################
#ifndef TOBII_OUTPUTVIDEOSTREAM_CPP
#define TOBII_OUTPUTVIDEOSTREAM_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "OutputVideoStream.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###        CLASS OUTPUT-VIDEO-STREAM           ###
	// ##################################################

	OutputVideoStream::OutputVideoStream ( const QString& name, cv::Size size, double fps )
	: VideoStream( name )
	{
		if ( ! name.isEmpty() )
			this->open( name, size, fps );
	}

	OutputVideoStream::OutputVideoStream ( const OutputVideoStream& stream )
	: VideoStream( stream ), cv::VideoWriter( stream )
	{}

	bool OutputVideoStream::open ( const QString& name )
	{
		return this->open( name, cv::Size(720, 405), 25 );
	}

	bool OutputVideoStream::open ( const QString& name, cv::Size resolution, double fps )
	{
		this->name()		 	 = name;
		this->resolution()		 = resolution;
		this->fps() 			 = fps;
		this->format()			 = CV_8UC3;
		this->frameCount()		 = 0;
		this->currentTimeStamp() = 0;

		this->cv::VideoWriter::open( name.toStdString(), CV_FOURCC('M','P','E','G'), fps, resolution, true );

		return this->isOpen();
	}

	bool OutputVideoStream::isOpen () const
	{
		return this->cv::VideoWriter::isOpened();
	}

	bool OutputVideoStream::close ()
	{
		if ( this->isOpen() )
			this->cv::VideoWriter::release();
		return this->isOpen();
	}

	OutputVideoStream& OutputVideoStream::operator=( const OutputVideoStream& stream )
	{
		this->VideoStream::operator=( stream );
		this->cv::VideoWriter::operator=( stream );
		return (*this);
	}

	// END CLASS INPUT-VIDEO-STREAM
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_OUTPUTVIDEOSTREAM_CPP
// ##################################################