// ##################################################
// ###           TOBII_SYNCHRONIZER_HPP           ###
// ##################################################
#ifndef TOBII_SYNCHRONIZER_HPP
#define TOBII_SYNCHRONIZER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/DataPackets.hpp"
#include "TobiiSDK/Data/Frame.hpp"

// EXTERNAL LIBRARIES
#include <QObject>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###              CLASS SYNCHRONIZER            ###
	// ##################################################
	
	class Synchronizer : public QObject
	{
		Q_OBJECT
	private:
		Int64 _firstFrameTimeStamp;

	public:
		Synchronizer ( QObject* parent = NULL );
		virtual ~Synchronizer ();

		Int64	firstFrameTimeStamp	() const;
		Int64&	firstFrameTimeStamp	();

	private:
		Synchronizer ( const Synchronizer& ) = delete;
		Synchronizer& operator= ( const Synchronizer& ) = delete;

	public slots:
		DataPacketPtr synchronizeData  ( DataPacketPtr dataPacket );
		FramePtr	  synchronizeFrame ( FramePtr      frame      );

	signals:
		void dataSynchronized  ( DataPacketPtr dataPacket );
		void frameSynchronized ( FramePtr      frame      );

	}; // END CLASS SYNCHRONIZER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_SYNCHRONIZER_HPP
// ##################################################