// ##################################################
// ###           TOBII_SYNCHRONIZER_CPP           ###
// ##################################################
#ifndef TOBII_SYNCHRONIZER_CPP
#define TOBII_SYNCHRONIZER_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Synchronizer.hpp"
#include <iostream>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###              CLASS SYNCHRONIZER            ###
	// ##################################################
	
	Synchronizer::Synchronizer ( QObject* parent )
	: QObject( parent ), _firstFrameTimeStamp( 0 )
	{}

	Synchronizer::~Synchronizer ()
	{}

	Int64	Synchronizer::firstFrameTimeStamp	() const	{ return this->_firstFrameTimeStamp;	}
	Int64&	Synchronizer::firstFrameTimeStamp	()			{ return this->_firstFrameTimeStamp;	}

	DataPacketPtr Synchronizer::synchronizeData ( DataPacketPtr dataPacket )
	{
		if ( dataPacket )
		{
			if ( this->firstFrameTimeStamp() == 0 && dataPacket->name() == "pts" )
			{
				// TODO - LIVE SYNC HERE
			}
			else if ( this->firstFrameTimeStamp() == 0 && dataPacket->name() == "vts" )
			{
				this->firstFrameTimeStamp() = dataPacket->timeStamp();
			}

			dataPacket->timeStamp() -= this->firstFrameTimeStamp();
			dataPacket->timeStamp() /= 1000;

			emit this->dataSynchronized( dataPacket );
		}
		return dataPacket;
	}

	FramePtr Synchronizer::synchronizeFrame ( FramePtr frame )
	{
		emit this->frameSynchronized( frame );
		return frame;
	}

	// END CLASS SYNCHRONIZER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_SYNCHRONIZER_CPP
// ##################################################