// ##################################################
// ###      TOBII_ORIENTATIONRECORDINGS_HPP       ###
// ##################################################
#ifndef TOBII_ORIENTATIONRECORDINGS_HPP
#define TOBII_ORIENTATIONRECORDINGS_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/Recordings.hpp"
#include "TobiiSDK/Data/DataPackets.hpp"
#include "TobiiSDK/Data/Orientation.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###         CLASS ORIENTATION-RECORDINGS       ###
	// ##################################################

	class OrientationRecordings : public Recordings< Orientation >
	{
	private:
		using Super = Recordings< Orientation >;

	public:
		OrientationRecordings ( Int64 bufferSize = 1 );
		OrientationRecordings ( const OrientationRecordings& recordings );
		virtual ~OrientationRecordings ();

		using Iterator = Super::Iterator;
		using ConstIterator = Super::ConstIterator;

		using Super::at;
		using Super::insert;

		OrientationRecordings& insert ( const GyroscopePacket* ptrPacket );

	public:
		OrientationRecordings& operator= ( const OrientationRecordings& recordings );
	};

	using OrientationRecordingsPtr = std::shared_ptr< OrientationRecordings >;

	// END CLASS ORIENTATION-RECORDINGS
	// ##################################################


} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_ORIENTATIONRECORDINGS_HPP
// ##################################################