// ##################################################
// ###         TOBII_GAZERECORDINGS_HPP           ###
// ##################################################
#ifndef TOBII_GAZERECORDINGS_HPP
#define TOBII_GAZERECORDINGS_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/Recordings.hpp"
#include "TobiiSDK/Data/GazeFixation.hpp"
#include "TobiiSDK/Data/DataPackets.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###             CLASS GAZERECORDINGS           ###
	// ##################################################

	class GazeRecordings : public Recordings< GazeFixation >
	{
	private:
		using Super = Recordings< GazeFixation >;

	public:
		GazeRecordings ( Int64 bufferSize = std::numeric_limits<Int64>::max() );
		GazeRecordings ( const GazeRecordings& recordings );
		virtual ~GazeRecordings ();

		using Iterator = Super::Iterator;
		using ConstIterator = Super::ConstIterator;

		using Super::begin;
		using Super::end;
		using Super::cbegin;
		using Super::cend;
		using Super::empty;
		using Super::size;
		using Super::erase;
		using Super::clear;
		using Super::find;
		using Super::insert;
		using Super::at;

		GazeRecordings& insert ( DataPacketPtr packet );
	private:
		GazeRecordings& insert ( const PupilCenterPacket*		packet );
		GazeRecordings& insert ( const PupilDiameterPacket*		packet );
		GazeRecordings& insert ( const GazeDirectionPacket*		packet );
		GazeRecordings& insert ( const Gaze2DPositionPacket*	packet );
		GazeRecordings& insert ( const Gaze3DPositionPacket*	packet );

	public:
		GazeRecordings& operator= ( const GazeRecordings& recordings );
	};

	using GazeRecordingsPtr = std::shared_ptr< GazeRecordings >;

	// END CLASS GAZERECORDINGS
	// ##################################################


} // END NAMESPACE TOBII
// ##################################################

#endif // GAZERECORDINGS_HPP
// ##################################################