// ##################################################
// ###     TOBII_ACCELERATIONRECORDINGS_HPP       ###
// ##################################################
#ifndef TOBII_ACCELERATIONRECORDINGS_HPP
#define TOBII_ACCELERATIONRECORDINGS_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/Recordings.hpp"
#include "TobiiSDK/Data/DataPackets.hpp"
#include "TobiiSDK/Data/Acceleration.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###         CLASS ACCELERATION-RECORDINGS      ###
	// ##################################################

	class AccelerationRecordings : public Recordings< Acceleration >
	{
	private:
		using Super = Recordings< Acceleration >;

	public:
		AccelerationRecordings ( Int64 bufferSize = 1 );
		AccelerationRecordings ( const AccelerationRecordings& recordings );
		virtual ~AccelerationRecordings ();

		using Iterator = Super::Iterator;
		using ConstIterator = Super::ConstIterator;

		using Super::at;
		using Super::insert;

		AccelerationRecordings& insert ( const AccelerometerPacket* ptrPacket );

	public:
		AccelerationRecordings& operator= ( const AccelerationRecordings& recordings );
	};

	using AccelerationRecordingsPtr = std::shared_ptr< AccelerationRecordings >;

	// END CLASS ACCELERATION-RECORDINGS
	// ##################################################


} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_ACCELERATIONRECORDINGS_HPP
// ##################################################