// ##################################################
// ###             TOBII_SALIENCY_HPP             ###
// ##################################################
#ifndef TOBII_SALIENCY_HPP
#define TOBII_SALIENCY_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STANDARDS LIBRARIES
#include <cmath>

// INTERNAL MODULES
#include "TobiiSDK/Data/GazeFixation.hpp"
#include "TobiiSDK/Data/Frame.hpp"

// EXTERNAL LIBRARIES
#include <opencv2/core/core.hpp>
#include <opencv2/contrib/contrib.hpp>
#include <opencv2/gpu/gpu.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###             NAMESPACE SALIENCY             ###
	// ##################################################	
	namespace Saliency {

		static const float PI      ( 3.14159265f ); // PI
		static const float alpha   ( 2.0f     ); // projection de la fovéa 2°
		static const float beta    ( 24.0f    ); // l'angle d'ouverture de la caméra sur l'axe 'x'
		static const float A       ( 1600.0f  ); // ponderation de la largeur de la carte de saillance en fonction de la distance
		static const float epsilon ( std::numeric_limits<float>::epsilon() ); // very small number

		float	sigmaAtResolution		( const cv::Size& resolution );
		float	computeSigma			( const GazeFixation& fixation, cv::Size resolution );
		Frame	computeSaliencyMap		( const GazeFixation& fixation, cv::Size resolution );
		Frame	computeSaliencyMapGPU	( const GazeFixation& fixation, cv::Size resolution );
		Frame	computeHeatMap			( const Frame& frame, const Frame& saliencyMap, double alpha = 0.6 );
		Frame	computeWeightedMap		( const Frame& frame, const Frame& saliencyMap );
		Frame	threshold				( const Frame& saliency, double threshold );

	} // END CLASS NAMESPACE SALIENCY
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_SALIENCY_HPP
// ##################################################