// ##################################################
// ###               FILEDEVICE_HPP               ###
// ##################################################
#ifndef FILEDEVICE_HPP
#define FILEDEVICE_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Device/Device.hpp"
#include "DataFileStreamer.hpp"
#include "VideoFileStreamer.hpp"

// EXTERNAL LIBRARIES
#include <QObject>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###               CLASS FILEDEVICE             ###
	// ##################################################
	
	class FileDevice : public Device
	{
		Q_OBJECT
	private:
		DataFileStreamer	_dataStreamer;
		VideoFileStreamer	_videoStreamer;

	public:
		FileDevice ( const cv::Size& resolution = cv::Size(), QObject* parent = NULL );
		FileDevice ( UInt8 width, UInt8 height, QObject* parent = NULL );
		virtual ~FileDevice ();

		virtual bool			hasFinished	() const;
		virtual const cv::Size&	resolution	() const;
		virtual cv::Size&		resolution	();

		const DataFileStreamer&		dataStreamer	() const;
		DataFileStreamer&			dataStreamer	();
		const VideoFileStreamer&	videoStreamer	() const;
		VideoFileStreamer&			videoStreamer	();

	public slots:
		virtual void startReading	( const QString& dataFileName = "", const QString& videoFileName = "" );
		virtual void stopReading	();
		virtual void finishReading	();

	private slots:
		void frameRead ( FramePtr frame );
		void videoReaderFinished ();
		void dataReaderFinished  ();

	signals:
		void frameAvailable	( FramePtr frame );
		void finished ();

	private:
		FileDevice ( const FileDevice& device ) = delete;
		FileDevice& operator= ( const FileDevice& device ) = delete;

	};

	using FileDevicePtr = std::shared_ptr< FileDevice >;

	// END CLASS FILEDEVICE
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // FILEDEVICE_HPP
// ##################################################