// ##################################################
// ###            TOBII_DATAPARSER_HPP            ###
// ##################################################
#ifndef TOBII_DATAPARSER_HPP
#define TOBII_DATAPARSER_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/DataPackets.hpp"

// EXTERNAL LIBRARIES
#include "rapidjson/document.h"
#include <QObject>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###              CLASS DATAPARSER              ###
	// ##################################################
	
	class DataParser : public QObject
	{
		Q_OBJECT
	public:
		DataParser ( QObject* parent = NULL );
		virtual ~DataParser ();

	private:
		DataParser ( const DataParser& parser ) = delete;
		DataParser& operator= ( const DataParser& parser ) = delete;

	signals:
		void dataAvailable ( DataPacketPtr packet ) const;

	public slots:
		void parseData ( const std::string& data ) const;

	private:
		DataPacketPtr			parseDataPacket				( const rapidjson::Document& json ) const;
		PupilCenterPacketPtr	parsePupilCenterPacket		( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		PupilDiameterPacketPtr	parsePupilDiameterPacket	( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		GazeDirectionPacketPtr	parseGazeDirectionPacket	( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		Gaze2DPositionPacketPtr	parseGaze2DPositionPacket	( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		Gaze3DPositionPacketPtr	parseGaze3DPositionPacket	( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		GyroscopePacketPtr		parseGyroscopePacket		( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		AccelerometerPacketPtr	parseAccelerometerPacket	( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		PTSSyncPacketPtr		parsePTSSyncPacket			( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
		VTSSyncPacketPtr		parseVTSSyncPacket			( Int64 timeStamp, UInt8 statuts, const rapidjson::Document& json ) const;
	
	}; // END CLASS DATAPARSER
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_DATAPARSER_HPP
// ##################################################