// ##################################################
// ###           TOBII_RECORDINGS_HPP              ###
// ##################################################
#ifndef TOBII_RECORDINGS_HPP
#define TOBII_RECORDINGS_HPP

/**
 * \file Recordings.hpp
 * \brief Describes all the data packets objects type, modeling all Tobii Glasses 2 live data stream contents .
 * \author PÉREZ DE SAN ROMAN Philippe
 * \date 16/02/2016
 * \version 1.0
 **/

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STANDARD LIBRARIES
#include <limits>
#include <map>

// INTERNAL MODULES
#include "Record.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
 namespace Tobii {

	// ##################################################
	// ###               CLASS RECORDINGS             ###
	// ##################################################

	template< typename Type >
	class Recordings : private std::map< Int64, Type >
	{
	private:
		bool	_limitSize;
		Int64	_bufferSize;
		using Super = std::map< Int64, Type >;

	public:
		Recordings ( Int64 bufferSize = std::numeric_limits<long long>::max() );
		Recordings ( const Recordings& recordings );
		virtual ~Recordings ();

		bool	isSizeLimited	() const;
		bool&	isSizeLimited	();
		Int64 	bufferSize		() const;
		Int64&	bufferSize		();

		using Iterator = typename Super::iterator;
		using ConstIterator = typename Super::const_iterator;

		using Super::begin;
		using Super::end;
		using Super::cbegin;
		using Super::cend;
		using Super::empty;
		using Super::size;
		using Super::erase;
		using Super::clear;
		using Super::find;

		const Type&	at ( Int64 timeStamp ) const;
		Type&		at ( Int64 timeStamp );
		Recordings& insert ( const Type& record );

		void setBufferSize ( Int64 size );
		
		Recordings& operator= ( const Recordings& recordings );
	
	}; // END CLASS RECORDINGS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

// ##################################################
// ###              IMPLEMENTATION                ###
// ##################################################

#include "Recordings.hxx"

#endif // TOBII_RECORDINGS_HPP
// ##################################################