// ##################################################
// ###              TOBII_RECORD_CPP               ###
// ##################################################
#ifndef TOBII_RECORD_CPP
#define TOBII_RECORD_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Record.hpp"

// ##################################################
// ###               NAMESPACE TOBII              ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS RECORD                ###
	// ##################################################

	Record::Record ( Int64 timeStamp, UInt8 status )
	: _timeStamp( timeStamp ), _status( status )
	{}

	Record::Record ( const Record& record )
	: _timeStamp( record.timeStamp() ), _status( record.status() )
	{}

	Record::~Record ()
	{}

	Int64  Record::timeStamp () const	{ return this->_timeStamp;	}
	Int64& Record::timeStamp ()			{ return this->_timeStamp;	}
	UInt8  Record::status	 ()	const	{ return this->_status;		}
	UInt8& Record::status	 ()			{ return this->_status;		}

	Record& Record::operator= ( const Record& record )
	{
		this->timeStamp() = record.timeStamp();
		this->status()    = record.status();
		return (*this);
	}

	// END CLASS RECORD
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_RECORD_CPP
// ##################################################