// ##################################################
// ###             TOBII_POINT3_CPP               ###
// ##################################################
#ifndef TOBII_POINT3_CPP
#define TOBII_POINT3_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Point3.hpp"

// ##################################################
// ###               NAMESPACE TOBII              ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS POINT3                ###
	// ##################################################

	Point3::Point3 ( float x, float y, float z )
	: _x( x ), _y( y ), _z( z )
	{}

	Point3::Point3 ( const Point3& point )
	: _x( point.x() ), _y( point.y() ), _z( point.z() )
	{}

	Point3 Point3::zero ()
	{
		return Point3();
	}

	float  Point3::x () const	{ return this->_x;	}
	float& Point3::x ()			{ return this->_x;	}
	float  Point3::y () const	{ return this->_y;	}
	float& Point3::y ()			{ return this->_y;	}
	float  Point3::z () const	{ return this->_z;	}
	float& Point3::z ()			{ return this->_z;	}

	float Point3::norm () const
	{
		return std::sqrt( square(this->x()) + square(this->y()) + square(this->z()) );
	}

	Point3::operator std::string () const
	{
		std::stringstream formatedOutput;
		formatedOutput << "[" << this->x() << "," << this->y() << "," << this->z() << "]";
		return formatedOutput.str();
	}

	Point3& Point3::operator= ( const Point3& point )
	{
		this->x() = point.x();
		this->y() = point.y();
		this->z() = point.z();
		return (*this);
	}

	// END CLASS POINT3
	// ##################################################

	std::ostream& operator<< ( std::ostream& ostream, const Point3& point )
	{
		return ostream << static_cast< std::string >( point );
	}

} // END NAMESPACE DATA
// ##################################################

#endif // TOBII_POINT3_CPP
// ##################################################