// ##################################################
// ###              TOBII_POINT2_CPP              ###
// ##################################################
#ifndef TOBII_POINT2_CPP
#define TOBII_POINT2_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Point2.hpp"

// ##################################################
// ###               NAMESPACE TOBII              ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                CLASS POINT2                ###
	// ##################################################

	Point2::Point2 ( float x, float y )
	: _x( x ), _y( y )
	{}

	Point2::Point2 ( const Point2& point )
	: _x( point.x() ), _y( point.y() )
	{}

	Point2 Point2::zero ()
	{
		return Point2();
	}

	float  Point2::x () const	{ return this->_x;	}
	float& Point2::x ()			{ return this->_x;	}
	float  Point2::y () const	{ return this->_y;	}
	float& Point2::y ()			{ return this->_y;	}

	Point2::operator std::string () const
	{
		std::stringstream formatedOutput;
		formatedOutput << "[" << this->x() << "," << this->y() << "]";
		return formatedOutput.str();
	}

	Point2& Point2::operator= ( const Point2& point )
	{
		this->x() = point.x();
		this->y() = point.y();
		return (*this);
	}

	// END CLASS POINT2
	// ##################################################

	std::ostream& operator<< ( std::ostream& ostream, const Point2& point )
	{
		return ostream << static_cast< std::string >( point );
	}

} // END NAMESPACE TOBII
// ##################################################

#endif // DATA_POINT2_CPP
// ##################################################