// ##################################################
// ###           TOBII_ORIENTATION_CPP            ###
// ##################################################
#ifndef TOBII_ORIENTATION_CPP
#define TOBII_ORIENTATION_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Orientation.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###              CLASS ORIENTATION             ###
	// ##################################################
	
	Orientation::Orientation ( Int64 timeStamp, UInt8 status, const Vector3& orientation )
	: Record( timeStamp, status ), Vector3( orientation )
	{}

	Orientation::Orientation ( const Orientation& orientation )
	: Record( orientation ), Vector3( orientation )
	{}

	Orientation::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"gy\":"	<< static_cast< const Vector3& >( *this )
		<< "}";

		return formatedOutput.str();
	}

	Orientation& Orientation::operator= ( const Vector3& orientation )
	{
		this->Vector3::operator=( orientation );
		return (*this);
	}


	Orientation& Orientation::operator= ( const Orientation& orientation )
	{
		this->Record::operator=( orientation );
		this->Vector3::operator=( orientation );
		return (*this);
	}

	// END CLASS ORIENTATION
	// ##################################################

	std::ostream& operator<< ( std::ostream& stream, const Orientation& orientation )
	{
		return stream << static_cast< std::string >( orientation );
	}

	std::ostream& operator<< ( const Orientation& orientation, std::ostream& stream )
	{
		return stream << static_cast< std::string >( orientation );
	}
	
} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_ORIENTATION_HPP
// ##################################################