// ##################################################
// ###               TOBII_EYE_HPP                ###
// ##################################################
#ifndef TOBII_EYE_CPP
#define TOBII_EYE_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Eye.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###                  CLASS EYE                 ###
	// ##################################################

	Eye::Eye ()
	: _validityFlag( NONE )
	{}

	Eye::Eye ( const Point3& pupilCenter, float pupilDiameter, const Vector3& gazeDirection )
	: _pupilCenter( pupilCenter ), _pupilDiameter( pupilDiameter ), _gazeDirection( gazeDirection ), _validityFlag( ALL )
	{}

	Eye::Eye ( const Eye& eye )
	: _pupilCenter( eye.pupilCenter() ), _pupilDiameter( eye.pupilDiameter() ), _gazeDirection( eye.gazeDirection() ), _validityFlag( eye.validityFlag() )
	{}

	const Point3&		Eye::pupilCenter	() const	{ return this->_pupilCenter;	}
	Point3&				Eye::pupilCenter	()			{ return this->_pupilCenter;	}
	float				Eye::pupilDiameter	() const	{ return this->_pupilDiameter;	}
	float&				Eye::pupilDiameter	()			{ return this->_pupilDiameter;	}
	const Vector3&		Eye::gazeDirection	() const	{ return this->_gazeDirection;	}
	Vector3&			Eye::gazeDirection	()			{ return this->_gazeDirection;	}
	Eye::ValidityFlag	Eye::validityFlag	() const	{ return this->_validityFlag;	}
	Eye::ValidityFlag&	Eye::validityFlag	()			{ return this->_validityFlag;	}

	Eye::operator std::string () const
	{
		std::stringstream formatedOutput;
		formatedOutput
			<< "{"
			<< "\"pc\":" << this->pupilCenter()   << ","
			<< "\"pd\":" << this->pupilDiameter() << ","
			<< "\"gd\":" << this->gazeDirection()
			<< "}";

		return formatedOutput.str();
	}

	bool Eye::isFieldSet ( ValidityFlag field ) const
	{
		return ( this->validityFlag() & field );
	}

	bool Eye::isSet () const
	{
		return this->isFieldSet( ValidityFlag::ALL );
	}

	void Eye::setFieldValidity ( ValidityFlag field )
	{
		this->validityFlag() = this->validityFlag() | field;
	}

	void Eye::setPupilCenter ( const Point3& pupilCenter )
	{
		this->pupilCenter() = pupilCenter;
		this->setFieldValidity( ValidityFlag::PUPIL_CENTER );
	}

	void Eye::setPupilDiameter ( float diameter )
	{
		this->pupilDiameter() = diameter;
		this->setFieldValidity( ValidityFlag::PUPIL_DIAMETER );
	}

	void Eye::setGazeDirection ( const Vector3& gazeDirection )
	{
		this->gazeDirection() = gazeDirection;
		this->setFieldValidity( ValidityFlag::GAZE_DIRECTION );
	}

	Eye& Eye::operator= ( const Eye& eye )
	{
		this->pupilCenter()		= eye.pupilCenter();
		this->pupilDiameter()	= eye.pupilDiameter();
		this->gazeDirection()	= eye.gazeDirection();
		this->validityFlag()	= eye.validityFlag();
		return (*this);
	}

	// END CLASS EYE
	// ##################################################
	
	// ##################################################
	// ###            LOGICAL OPERATORS               ###
	// ##################################################

	Eye::ValidityFlag operator| ( Eye::ValidityFlag flag1, Eye::ValidityFlag flag2 )
	{
		return static_cast< Eye::ValidityFlag >( static_cast< short >(flag1) | static_cast< short >(flag2) );
	}

	// END LOGICAL OPERATORS
	// ##################################################

	// ##################################################
	// ###      STREAM CONCATENATION OPERATORS        ###
	// ##################################################

	std::ostream& operator<< ( std::ostream& ostream, const Eye::ValidityFlag validityFlag )
	{
		return ostream << static_cast< short >( validityFlag );
	}

	std::ostream& operator<< ( std::ostream& ostream, const Eye& eye )
	{
		return ostream << static_cast< std::string >( eye );
	}

	// END STREAM CONCATENATION OPERATORS
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_EYE_HPP
// ##################################################