// ##################################################
// ###          TOBII_ACCELERATION_CPP            ###
// ##################################################
#ifndef TOBII_ACCELERATION_CPP
#define TOBII_ACCELERATION_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "Acceleration.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###              CLASS ACCELERATION            ###
	// ##################################################

	Acceleration::Acceleration ( Int64 timeStamp, UInt8 status, const Vector3& acc )
	: Record( timeStamp, status ), Vector3( acc )
	{}

	Acceleration::Acceleration ( const Acceleration& acc )
	: Record( acc ), Vector3( acc )
	{}

	Acceleration::operator std::string () const
	{
		std::stringstream formatedOutput;
		
		formatedOutput
			<< "{\"ts\":"	<< this->timeStamp()
			<< ",\"s\":"	<< this->status()
			<< ",\"ac\":"	<< static_cast< const Vector3& >( *this )
		<< "}";

		return formatedOutput.str();
	}

	Acceleration& Acceleration::operator= ( const Vector3& acc )
	{
		this->Vector3::operator=( acc );
		return (*this);
	}

	Acceleration& Acceleration::operator= ( const Acceleration& acc )
	{
		this->Record::operator=( acc );
		this->Vector3::operator=( acc );
		return (*this);
	}

	// END CLASS ACCELERATION
	// ##################################################

	std::ostream& operator<< ( std::ostream& stream, const Acceleration& acc )
	{
		return stream << static_cast< std::string >( acc );
	}

	std::ostream& operator<< ( const Acceleration& acc, std::ostream& stream )
	{
		return stream << static_cast< std::string >( acc );
	}

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_ACCELERATION_CPP
// ##################################################