// ##################################################
// ###            TOBII_APPLICATION_HPP           ###
// ##################################################
#ifndef TOBII_APPLICATION_HPP
#define TOBII_APPLICATION_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// STADARD LIBRARIES
#include <iomanip>
#include <iostream>
#include <string>

// INTERNAL MODULES
#include "TobiiSDK.hpp"

// EXTERNAL LIBRARY
#include <QDir>
#include <QObject>
#include <QMutex>
#include <opencv2/highgui/highgui.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################
namespace Tobii {

	// ##################################################
	// ###             CLASS APPLICATION              ###
	// ##################################################
	
	class Application : public TobiiSDK
	{
		Q_OBJECT
	private:
		QString			_name, _recordFile, _dumpFolder;
		bool			_display, _record, _dump;
		cv::VideoWriter _recorder;

	public:
		Application ( const int argc, const char* argv[] );
		virtual ~Application ();
		
		const QString&			name		() const;
		QString&				name		();
		const QString&			recordFile	() const;
		QString&				recordFile	();
		const QString&			dumpFolder	() const;
		QString&				dumpFolder	();
		bool					display		() const;
		bool&					display		();
		bool					record		() const;
		bool&					record		();
		bool					dump		() const;
		bool&					dump		();
		const cv::VideoWriter&	recorder	() const;
		cv::VideoWriter&		recorder	();

		virtual void		parseOptions	( int argc, const char* argv[], int minNbArgs = 0 );
		virtual QString 	usage			() const;
		virtual QString		help			() const;
		virtual int			run				() = 0;

		void displayFrame	( const cv::Mat& frame );
		void dumpFrame		( const Frame& frame, const QString& frameName = "frame" );
		void dumpFrame		( const cv::Mat& frame, Int64 timeStamp, const QString& frameName = "frame" );
		void recordFrame	( const cv::Mat& frame );
		
	private:
		Application ( const Application& ) = delete;
		Application& operator= ( const Application& ) = delete;

	}; // END CLASS APPLICATION
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_APPLICATION_HPP
// ##################################################
