# GNU Make solution makefile autogenerated by Premake
# Type "make help" for usage help

ifndef config
  config=debug32
endif
export config

PROJECTS := gtest unittest perftest

.PHONY: all clean help $(PROJECTS)

all: $(PROJECTS)

gtest: 
	@echo "==== Building gtest ($(config)) ===="
	@${MAKE} --no-print-directory -C . -f gtest.make

unittest: gtest
	@echo "==== Building unittest ($(config)) ===="
	@${MAKE} --no-print-directory -C . -f unittest.make

perftest: gtest
	@echo "==== Building perftest ($(config)) ===="
	@${MAKE} --no-print-directory -C . -f perftest.make

clean:
	@${MAKE} --no-print-directory -C . -f gtest.make clean
	@${MAKE} --no-print-directory -C . -f unittest.make clean
	@${MAKE} --no-print-directory -C . -f perftest.make clean

help:
	@echo "Usage: make [config=name] [target]"
	@echo ""
	@echo "CONFIGURATIONS:"
	@echo "   debug32"
	@echo "   release32"
	@echo "   debug64"
	@echo "   release64"
	@echo ""
	@echo "TARGETS:"
	@echo "   all (default)"
	@echo "   clean"
	@echo "   gtest"
	@echo "   unittest"
	@echo "   perftest"
	@echo ""
	@echo "For more information, see http://industriousone.com/premake/quick-start"
