#!/bin/bash
call_dir="$(pwd)"
current_dir="$(cd "$(dirname "$0")"; pwd)"
root_dir="$(cd "$current_dir"; cd ..; pwd)"
cmake_dir="$root_dir/CMake"
build_dir="$root_dir/Build"

# echo "root directory    : $root_dir"
# echo "current directory : $current_dir"
# echo "cmake directory   : $cmake_dir"
# echo "build directory   : $build_dir"

if [ $# == '0' ] ; then
	echo "USAGE   : Compile.command [target], type \"./Compile -help\" for more informations"

elif [ $1 == "-help" ] ; then
	echo "USAGE   : \"Compile.command [target]\". Available targets are :"
	echo "    -cmake     : run cmake"
	echo "    -make      : run make"
	echo "    -install   : run both cmake and make"
	echo "    -clean     : delete compiled files"
	echo "    -uninstall : delete all but sources"

elif [ $1 == "-cmake" ] ; then
	clear
	mkdir "$cmake_dir"
	cd "$cmake_dir"
	cmake "$current_dir"
	cd "$call_dir"

elif [ $1 == "-make" ] ; then
	clear
	if [ ! -d "$cmake_dir" ]; then
 		mkdir "$cmake_dir"
 		cmake "$current_dir"
 		cd "$call_dir"
	fi
	cd "$cmake_dir"
	make -j8
	cd "$call_dir"

elif [ $1 == "-install" ] ; then
	clear
	mkdir "$cmake_dir"
	cd "$cmake_dir"
	cmake "$current_dir"
	make -j8
	cd "$call_dir"

elif [ $1 == "-clean" ] ; then
	if [ -d "$cmake_dir" ]; then
		cd "$cmake_dir"
		make clean
		"$call_dir"
	fi
	clear

elif [ $1 == "-uninstall" ] ; then
	rm -dRf "$cmake_dir" "$build_dir"
	clear

fi