// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// STANDARD DEPENDANCES:
#include <iostream>

// QT5 CORE DEPENDANCES:
#include <QDir>
#include <QString>
#include <QMutex>
#include <QThread>

// OPENCV 2.4.11 DEPENDANCES:
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

// INTERNAL MODULES:
#include "ProjectSampler.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###         CLASS WORKSPACESAMPLER             ###
	// ##################################################

	using ThreadArray     = std::vector< QThread*          >;
	using SamplerArray    = std::vector< ProjectSampler*   >;
	using PendingProjects = std::vector< PendingProjectPtr >;

	class WorkspaceSampler : public QObject, public IndexManager
	{
		Q_OBJECT
	private:
		int				_nbThreads;
		ThreadArray		_threads;
		SamplerArray	_samplers;
		PendingProjects	_pendingProjects;
		cv::Size		_samplingResolution;

	public:
		WorkspaceSampler ( const QString& workspacePath, const QString& outputPath, int nbThreads = QThread::idealThreadCount() );
		virtual ~WorkspaceSampler ();

		int						nbThreads			() const;
		int&					nbThreads			();
		const ThreadArray&		threads				() const;
		ThreadArray&			threads				();
		const SamplerArray&		samplers			() const;
		SamplerArray&			samplers			();
		const PendingProjects&	pendingProjects		() const;
		PendingProjects&		pendingProjects		();
		const cv::Size&			samplingResolution	() const;
		cv::Size&				samplingResolution	();

		const QThread*			threadAt			( int index ) const;
		QThread*&				threadAt			( int index );
		const ProjectSampler*	samplerAt			( int index ) const;
		ProjectSampler*&		samplerAt			( int index );

		void initThreads ( int nbThreads = QThread::idealThreadCount() );
		void stopThreads ();

		bool samplingFinished ();

	public slots:
		void sampleProject	 ( const QString& videoPath = "" );
		void sampleWorkspace ( const cv::Size& samplingResolution );

	protected slots:
		void samplingFailed		( const QString& videoName, const QString& error );
		void samplingProgressed	( const QString& videoName, int currentIndex, int lastIndex );
		void samplingComplete	( const QString& videoName );
	
	signals:
		void startSamplingProject ( Sampling::PendingProjectPtr ptrPendingProject, const QString& outputPath );
	
	}; // END CLASS WORKSPACE SAMPLER
	// ##################################################

} // END NAMESPACE SAMPLING
// ##################################################