// ##################################################
// ###            MATCHING_UTILS_CPP              ###
// ##################################################
#ifndef MATCHING_UTILS_CPP
#define MATCHING_UTILS_CPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include "Utils.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	int randIn( int a, int b )
	{
		if ( a >= b )
			return -1;
		return rand() % ( b - a ) + a;
	}

	cv::Rect unionOfAll ( const RectArray& rectangles )
	{
		cv::Rect uni = rectangles.at(0);
		for ( int index(1) ; index < rectangles.size() ; ++index )
			uni = uni | rectangles.at(index);
		return uni;
	}

	double IoU ( const cv::Rect& A, const cv::Rect& B )
	{
		return ( static_cast<double>((A & B).area()) / static_cast<double>((A | B).area()) * 100.0 );
	}

	cv::Rect randomRect ( const cv::Size& minSize, const cv::Rect& limits, bool square )
	{
		cv::Rect randRect;
		do {
			randRect.x      = randIn( limits.x,      limits.x + limits.width  );
			randRect.y      = randIn( limits.y,      limits.y + limits.height );
			randRect.width  = randIn( minSize.width, limits.x + limits.width  - randRect.x );
			randRect.height = randIn( minSize.width, limits.y + limits.height - randRect.y );

		} while ( randRect.width == -1 || randRect.height == -1 );

		if ( square )
		{
			if ( randRect.width <= randRect.height )
				randRect.height = randRect.width;
			else
				randRect.width = randRect.height;
		}
		return randRect;
	}

	void syncPrint( const QString& text )
	{
		static QMutex mutex;
		mutex.lock();
		std::cout << text << std::endl << std::flush;
		mutex.unlock();
	}


	void syncWarning ( const QString& text )
	{
		cerrMutex.lock();
		std::cerr << text << std::endl << std::flush;
		cerrMutex.unlock();
	}

	void syncError ( const QString& text )
	{
		cerrMutex.lock();
		std::cerr << text << std::endl << std::flush;
		cerrMutex.unlock();
		std::exit(EXIT_FAILURE);
	}

} // END NAMESPACE SAMPLING
// ##################################################

std::ostream& operator<<( std::ostream& stream, const cv::Size& size )
{
	stream << size.width << "x" << size.height;
	return stream;
}

std::ostream& operator<<( std::ostream& stream, const QString& string )
{
	stream << string.toStdString();
	return stream;
}

std::ostream& operator<<( std::ostream& stream, const QStringList& lst )
{
	stream << "[";
	for ( int index(0) ; index < lst.size()-1 ; ++index )
	{
		stream << lst.at(index) << ", ";
	}
	stream << lst.at(lst.size()-1) << "]";
	return stream;
}

#endif // MATCHING_UTILS_CPP
// ##################################################