// ##################################################
// ###              SAMPLINGMODE_HPP              ###
// ##################################################
#ifndef SAMPLINGMODE_HPP
#define SAMPLINGMODE_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// QT5 CORE DEPENDANCES:
#include <QString>
#include <QTextStream>

// INTERNAL DEPENDANCES
#include "Utils.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###           CLASS SAMPLINGMODE               ###
	// ##################################################

	class SamplingMode
	{	
		// --------------------------------------------------
		// MEMBERS
	private:
		enum Mode { NONE = 0, TRAIN = 1, VALIDATION = 2, TEST = 3 };
		Mode _mode;

		Mode  mode () const;
		Mode& mode ();

		// --------------------------------------------------
		// CONSTRUCTOR
	public:
		SamplingMode ();
		SamplingMode ( const SamplingMode& mode );
		SamplingMode& operator= ( const SamplingMode& mode );
	private:
		SamplingMode ( Mode mode );

	public:
		static SamplingMode None ();
		static SamplingMode Train ();
		static SamplingMode Validation ();
		static SamplingMode Test ();

		// --------------------------------------------------
		// GETTERS - SETTERS
	public:
		operator QString () const;
		bool operator== ( const SamplingMode& mode ) const;
		bool operator!= ( const SamplingMode& mode ) const;

	};

	// END CLASS SAMPLINGMODE
	// ##################################################

	QTextStream& operator<< ( QTextStream& stream, const SamplingMode& mode );
	std::ostream& operator<< ( std::ostream& stream, const SamplingMode& mode );

} // END NAMESPACE SAMPLING
// ##################################################

#endif // SAMPLINGMODE_HPP
// ##################################################