// ##################################################
// ###              SAMPLINGMODE_CPP              ###
// ##################################################
#ifndef SAMPLINGMODE_CPP
#define SAMPLINGMODE_CPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include "SamplingMode.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###           CLASS SAMPLINGMODE               ###
	// ##################################################

	// --------------------------------------------------
	// MEMBERS

	SamplingMode::Mode  SamplingMode::mode () const	{ return this->_mode;	}
	SamplingMode::Mode& SamplingMode::mode ()		{ return this->_mode;	}

	// --------------------------------------------------
	// CONSTRUCTOR

	SamplingMode::SamplingMode ()
	: _mode( Mode::NONE )
	{}

	SamplingMode::SamplingMode ( Mode mode )
	: _mode( mode )
	{}

	SamplingMode::SamplingMode ( const SamplingMode& mode )
	: _mode( mode.mode() )
	{}

	SamplingMode& SamplingMode::operator= ( const SamplingMode& mode )
	{
		this->mode() = mode.mode();
		return (*this);
	}

	SamplingMode SamplingMode::None ()		 { return SamplingMode(Mode::NONE);			}
	SamplingMode SamplingMode::Train ()		 { return SamplingMode(Mode::TRAIN);		}
	SamplingMode SamplingMode::Validation () { return SamplingMode(Mode::VALIDATION);	}
	SamplingMode SamplingMode::Test ()		 { return SamplingMode(Mode::TEST);			}

	// --------------------------------------------------
	// GETTERS - SETTERS

	SamplingMode::operator QString () const
	{
		switch ( this->mode() )
		{
		case Mode::TRAIN:
			return QString("Train");
		case Mode::VALIDATION:
			return QString("Validation");
		case Mode::TEST:
			return QString("Test");
		default:
			return QString("None");
		}
	}

	bool SamplingMode::operator== ( const SamplingMode& mode ) const
	{
		return this->mode() == mode.mode();
	}

	bool SamplingMode::operator!= ( const SamplingMode& mode ) const
	{
		return this->mode() != mode.mode();
	}

	// END CLASS SAMPLINGMODE
	// ##################################################

	QTextStream& operator<< ( QTextStream& stream, const SamplingMode& mode )
	{
		return stream << static_cast< QString >( mode );
	}

	std::ostream& operator<< ( std::ostream& stream, const SamplingMode& mode )
	{
		return stream << static_cast< QString >( mode );
	}

} // END NAMESPACE SAMPLING
// ##################################################

#endif // SAMPLINGMODE_CPP
// ##################################################