// ##################################################
// ###             PROJECTSAMPLER_HPP              ###
// ##################################################
#ifndef PROJECTSAMPLER_HPP
#define PROJECTSAMPLER_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// STANDARD DEPENDANCES:
#include <iostream>

// QT5 CORE DEPENDANCES:
#include <QDir>
#include <QString>
#include <QThread>

// OPENCV 2.4.11 DEPENDANCES:
#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>

// INTERNAL MODULES:
#include "PendingProject.hpp"
#include "SamplingTools.hpp"
#include "IndexManager.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###           CLASS PROJECTSAMPLER             ###
	// ##################################################

	class ProjectSampler : public QObject
	{
		Q_OBJECT
	private:
		IndexManager*		_ptrIndexManager;
		PendingProjectPtr	_ptrPendingTask;
		cv::Size			_samplingResolution;
		bool				_isBusy;

	public:
		ProjectSampler ( IndexManager* ptrIndexFile = NULL );

		const IndexManager*			ptrIndexManager		() const;
		IndexManager*&				ptrIndexManager		();
		const PendingProjectPtr&	ptrPendingProject	() const;
		PendingProjectPtr&			ptrPendingProject	();
		const cv::Size&				samplingResolution	() const;
		cv::Size&					samplingResolution	();
		bool						isBusy				() const;
		bool&						isBusy				();

	public slots:
		void sampleFrame	( const cv::Mat& image, const cv::Mat& mask, const QString& prefixFG, const QString& prefixBG );
		void sampleProject	( Sampling::PendingProjectPtr ptrProject, const QString& outputPath );

	signals:
		void samplingFailed		( const QString& videoName, const QString& error );
		void samplingProgessed	( const QString& videoName, int currentIndex, int lastIndex );
		void samplingComplete	( const QString& videoName );
	
	}; // END CLASS PROJECTSAMPLER
	// ##################################################

} // END NAMESPACE SAMPLING
// ##################################################

#endif // PROJECTSAMPLER_HPP
// ##################################################