// ##################################################
// ###             PENDINGPROJECT_HPP             ###
// ##################################################
#ifndef PENDINGPROJECT_HPP
#define PENDINGPROJECT_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// INERNAL DEPENDANCES:
#include "TobiiSDK/Stream/Project.hpp"

// INTERNAL DEPENDANCES:
#include "SamplingMode.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###          CLASS PENDINGPROJECT              ###
	// ##################################################

	class PendingProject : public Tobii::Project
	{	
		// --------------------------------------------------
		// MEMBERS
	private:
		SamplingMode _mode;

		// --------------------------------------------------
		// CONSTRUCTOR
	public:
		PendingProject ( const QString& folder, SamplingMode mode = SamplingMode::None() );
		PendingProject ( const PendingProject& task );
		PendingProject& operator= ( const PendingProject& task );

		SamplingMode	mode () const;
		SamplingMode&	mode ();
	};

	using PendingProjectPtr = std::shared_ptr< PendingProject >;

	// END CLASS PENDINGPROJECT
	// ##################################################

} // END NAMESPACE SAMPLING
// ##################################################

Q_DECLARE_METATYPE( Sampling::PendingProjectPtr );

#endif // PENDINGPROJECT_HPP
// ##################################################