// ##################################################
// ###             PENDINGPROJECT_CPP             ###
// ##################################################
#ifndef PENDINGPROJECT_CPP
#define PENDINGPROJECT_CPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include "PendingProject.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###          CLASS PENDINGPROJECT              ###
	// ##################################################

	// --------------------------------------------------
	// CONSTRUCTOR

	PendingProject::PendingProject ( const QString& folder, SamplingMode mode )
	: Project( folder ), _mode( mode )
	{}

	PendingProject::PendingProject ( const PendingProject& task )
	: Project( task ), _mode( task.mode() )
	{}

	PendingProject& PendingProject::operator= ( const PendingProject& task )
	{
		this->Project::operator=( task );
		this->mode() = task.mode();
		return (*this);
	}

	SamplingMode	PendingProject::mode () const	{ return this->_mode;	}
	SamplingMode&	PendingProject::mode ()		{ return this->_mode;	}

	// END CLASS PENDINGPROJECT
	// ##################################################

} // END NAMESPACE SAMPLING
// ##################################################

#endif // PENDINGPROJECT_CPP
// ##################################################