// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// STANDARD DEPENDANCES:
#include <vector>
#include <list>
#include <iostream>

// QT5 CORE DEPENDANCES:
#include <QApplication>
#include <QDir>
#include <QString>

// INTERNAL MODULES:
#include "WorkspaceSampler.hpp"

// ##################################################
// ###                   MACRO                    ###
// ##################################################

#define ArgStr( index, defaultValue ) ( (index < argc) ? argv[index] : defaultValue )
#define ArgInt( index, defaultValue ) ( (index < argc) ? atoi(argv[index]) : defaultValue )

// ##################################################
// ###              MAIN FUNCTION                 ###
// ##################################################

int main ( int argc, char* argv[] )
{
	QApplication app( argc, argv );

	// --------------------------------------------------
	// Arguments:
	QString workspacePath = ArgStr( 1, "./WorkSpace/DataSet" );
	QString    outputPath = ArgStr( 2, "./WorkSpace/Samples" );
	
	cv::Size resolution( ArgInt( 3, 227 ),  ArgInt( 4, 227 ) );

	// Start the workspace sampler thread:
	Sampling::WorkspaceSampler sampler( workspacePath, outputPath );

	// Initiate sampling:
	sampler.sampleWorkspace( resolution );

	return EXIT_SUCCESS;
}