// ##################################################
// ###             INDEXMANAGER_HPP               ###
// ##################################################
#ifndef INDEXMANAGER_HPP
#define INDEXMANAGER_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// STANDARD LIBRARIES:
#include <vector>

// QT5 CORE DEPENDANCES:
#include <QString>
#include <QTextStream>

// INERNAL DEPENDANCES:
#include "IndexFile.hpp"
#include "SamplingMode.hpp"
#include "Categories.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###           CLASS INDEXMANAGER               ###
	// ##################################################

	using IndexFiles = HashMap< QString, IndexFilePtr >;

	class IndexManager
	{	
		// --------------------------------------------------
		// MEMBERS
	private:
		QString		_workspacePath, _outputPath;
		Categories	_categories;
		IndexFiles	_indexFiles;

		// --------------------------------------------------
		// CONSTRUCTOR
	public:
		IndexManager ( const QString& workspacePath, const QString& outputPath );

		// --------------------------------------------------
		// GETTERS - SETTERS

		const QString&		workspacePath	() const;
		QString&			workspacePath	();
		const QString&		outputPath		() const;
		QString&			outputPath		();
		const Categories&	categories		() const;
		Categories&			categories		();
		const IndexFiles&	indexFiles		() const;
		IndexFiles&			indexFiles		();

		void setCategories ( const Categories& categories );

		void addIndexFile ( const QString& name );
		void addIndexFile ( const SamplingMode& mode );

		const IndexFilePtr	indexFileByName ( const QString& name ) const;	
		IndexFilePtr		indexFileByName ( const QString& name );
		const IndexFilePtr	indexFileByMode ( const SamplingMode& mode ) const;	
		IndexFilePtr		indexFileByMode ( const SamplingMode& mode );

		void addIndex ( const SamplingMode& mode, const QString& fullpath, const QString& category );
		void addIndex ( const QString& projectName, const QString& category, int timestamp, const QString& fullpath );
	};

	using IndexManagerPtr = std::shared_ptr< IndexManager >;

	// END CLASS INDEXMANAGER
	// ##################################################

	QTextStream& operator<< ( QTextStream& stream, const IndexManager& indexManager );

} // END NAMESPACE SAMPLING
// ##################################################

#endif // INDEXMANAGER_HPP
// ##################################################