// ##################################################
// ###                INDEXFILE_HPP               ###
// ##################################################
#ifndef INDEXFILE_HPP
#define INDEXFILE_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// QT5 CORE DEPENDANCES:
#include <QFile>
#include <QMutex>
#include <QString>
#include <QTextStream>

// INTERNAL DEPENDANCES
#include "Utils.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###            CLASS INDEXFILE                 ###
	// ##################################################

	using BigInt = unsigned long long;
	using Counters = HashMap< int, BigInt >;

	class IndexFile
	{	
		// --------------------------------------------------
		// MEMBERS
	public:
		QFile		_file;
		QTextStream	_stream;
		QMutex		_mutex;
		Counters	_counters;

		// --------------------------------------------------
		// CONSTRUCTOR
	public:
		IndexFile ( const QString& filename );

		// --------------------------------------------------
		// GETTERS - SETTERS

		const QFile&		file		() const;
		QFile&				file		();
		const QTextStream&	stream		() const;
		QTextStream&		stream		();
		const QMutex&		mutex		() const;
		QMutex&				mutex		();
		const Counters&		counters	() const;
		Counters&			counters	();

		void lock	();
		void unlock	();

		void    addCounter     ( int label );
		BigInt  counterByLabel ( int label ) const;
		BigInt& counterByLabel ( int label );

		IndexFile& operator<< ( const QString& line );

	public:
		void addIndex ( const QString& fullpath, int label );
		void addIndex ( const QString& projectName, const QString& category, int label, int timestamp, const QString& fullpath );
	};

	using IndexFilePtr = std::shared_ptr< IndexFile >;

	// END CLASS INDEXFILE
	// ##################################################

	QTextStream& operator<< ( QTextStream& stream, const IndexFile& indexFile );

} // END NAMESPACE SAMPLING
// ##################################################

#endif // INDEXFILE_HPP
// ##################################################