// ##################################################
// ###                INDEXFILE_CPP               ###
// ##################################################
#ifndef INDEXFILE_CPP
#define INDEXFILE_CPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include "IndexFile.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###            CLASS INDEXFILE                 ###
	// ##################################################

	// --------------------------------------------------
	// CONSTRUCTOR

	IndexFile::IndexFile ( const QString& filename )
	: _file( filename )
	{
		if ( ! this->file().open(QIODevice::WriteOnly | QIODevice::Text) )
			syncError( QString("Could not open IndexFile \"%1\"").arg(filename) );

		this->stream().setDevice( &this->file() );
	}

	// --------------------------------------------------
	// GETTERS - SETTERS

	const QFile&		IndexFile::file		() const	{ return this->_file;		}
	QFile&				IndexFile::file		()			{ return this->_file;		}
	const QTextStream&	IndexFile::stream	() const	{ return this->_stream;		}
	QTextStream&		IndexFile::stream	()			{ return this->_stream;		}
	const QMutex&		IndexFile::mutex	() const	{ return this->_mutex;		}
	QMutex&				IndexFile::mutex	()			{ return this->_mutex;		}
	const Counters&		IndexFile::counters	() const	{ return this->_counters;	}
	Counters&			IndexFile::counters	()			{ return this->_counters;	}

	void IndexFile::lock	()	{ this->mutex().lock();		}
	void IndexFile::unlock	()	{ this->mutex().unlock();	}

	void IndexFile::addCounter ( int label )
	{
		this->counters().emplace( label, 0 );
	}

	BigInt  IndexFile::counterByLabel ( int label ) const { return this->counters().at(label);	}
	BigInt& IndexFile::counterByLabel ( int label )		  { return this->counters().at(label);	}

	IndexFile& IndexFile::operator<< ( const QString& line )
	{
		this->stream() << line << endl;
		return (*this);
	}

	void IndexFile::addIndex ( const QString& fullpath, int label )
	{
		this->lock();
		this->counterByLabel(label)++;
		*this << QString("%1 %2")
			.arg(fullpath)
			.arg(label);
		this->unlock();
	}

	void IndexFile::addIndex ( const QString& projectName, const QString& category, int label, int timestamp, const QString& fullpath )
	{
		this->lock();
		this->counterByLabel(label)++;
		*this << QString("%1\t%2\t%3\t%4\t%5")
			.arg(projectName)
			.arg(category)
			.arg(label)
			.arg(timestamp)
			.arg(fullpath);
		this->unlock();
	}

	// IndexFile& IndexFile::operator<< ( const Index& index )
	// {
	// 	this->lock();
	// 	this->stream() << index.fullpath << ' ' << index.label << endl;
	// 	this->unlock();
	// 	return (*this);
	// }
		
	// END CLASS INDEXFILE
	// ##################################################

	QTextStream& operator<< ( QTextStream& stream, const IndexFile& indexFile )
	{
		for ( auto entry : indexFile.counters() )
			stream << entry.first << '\t' << entry.second << endl;
		return stream;
	}

} // END NAMESPACE SAMPLING
// ##################################################

#endif // INDEXFILE_CPP
// ##################################################