// ##################################################
// ###               CATEGORIES_HPP               ###
// ##################################################
#ifndef CATEGORIES_HPP
#define CATEGORIES_HPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

// QT5 CORE DEPENDANCES:
#include <QString>
#include <QTextStream>

// INTERNAL DEPENDANCES
#include "Utils.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###            CLASS CATEGORIES                ###
	// ##################################################

	class Categories : public Array< QString >
	{	
		// --------------------------------------------------
		// CONSTRUCTOR
	public:
		Categories ();
		Categories ( const Categories& categories );
		Categories& operator= ( const Categories& categories );

		// --------------------------------------------------
		// GETTERS - SETTERS

		bool	categoryExists	( const QString& category ) const;
		int		labelOfCategory	( const QString& category ) const;
		QString	categoryOfLabel	( int label ) const;

		void	addCategory		( const QString& category );
	};

	// END CLASS CATEGORIES
	// ##################################################

	QTextStream& operator>> ( QTextStream& stream, Categories& categories );
	QTextStream& operator<< ( QTextStream& stream, const Categories& categories );

} // END NAMESPACE SAMPLING
// ##################################################

#endif // CATEGORIES_HPP
// ##################################################