// ##################################################
// ###             CATEGORIES_CPP                 ###
// ##################################################
#ifndef CATEGORIES_CPP
#define CATEGORIES_CPP

// ##################################################
// ###                DEPENDANCES                 ###
// ##################################################

#include "Categories.hpp"

// ##################################################
// ###           NAMESPACE SAMPLING               ###
// ##################################################

namespace Sampling {

	// ##################################################
	// ###            CLASS CATEGORIES                ###
	// ##################################################

	// --------------------------------------------------
	// CONSTRUCTOR

	Categories::Categories ()
	{}

	Categories::Categories ( const Categories& categories )
	: Array< QString >( categories )
	{}

	Categories& Categories::operator= ( const Categories& categories )
	{
		this->Array< QString >::operator=( categories );
		return (*this);
	}

	// --------------------------------------------------
	// GETTERS - SETTERS

	bool Categories::categoryExists	( const QString& category ) const
	{
		return std::find( this->begin(), this->end(), category ) != this->end();
	}

	int Categories::labelOfCategory	( const QString& category ) const
	{
		return std::find(this->begin(), this->end(), category) - this->begin();
	}

	QString	Categories::categoryOfLabel	( int label ) const
	{
		return this->at(label);
	}

	void Categories::addCategory ( const QString& category )
	{
		if ( ! this->categoryExists(category) )
		{
			this->push_back(category);
			std::sort( this->begin(), this->end() );
		}
	}

	// END CLASS CATEGORIES
	// ##################################################

	QTextStream& operator>> ( QTextStream& stream, Categories& categories )
	{
		categories.clear();
		categories.addCategory("Background");
		while ( ! stream.atEnd() )
		{
			QString category = stream.readLine();
			if ( category != "Bad" && category != "Unknown" )
				categories.addCategory( category );
		}
		return stream;
	}

	QTextStream& operator<< ( QTextStream& stream, const Categories& categories )
	{
		for ( int id(0) ; id < categories.size() ; ++id )
			stream << id << ':' << categories.at(id) << endl;
		
		return stream;
	}

} // END NAMESPACE SAMPLING
// ##################################################

#endif // CATEGORIES_CPP
// ##################################################