#include "Stats.hpp"
namespace SMI
{
Stats::Stats(int frameCount)
   : _frameCount(frameCount)
 {}

int Stats::processStats(std::string videoName, std::string fileName)
{	
  std::ofstream statsFile(fileName, std::ios_base::trunc);
  if(!statsFile)
  {
    std::cerr << "Couldn't open Stats file " << fileName << std::endl;
    return EXIT_FAILURE;
  }
  for (auto& mapItem : this->_statsMap)
  {
    statsFile << mapItem.first << '\t' << mapItem.second << std::endl;
  }
  return EXIT_SUCCESS;
}

void Stats::insert(std::string category, int value)
{
  if(this->_statsMap.count(category)) { this->_statsMap[category] += value; } 
  else                                { this->_statsMap.insert(std::pair<std::string, int>(category, value)); }
}
}
