#ifndef SMI_DATAPARSER_HPP
#define SMI_DATAPARSER_HPP

#include <iostream>
#include <fstream>
#include <boost/algorithm/string.hpp>
#include <string>
#include <opencv2/opencv.hpp>
#include "SMIData.hpp"
#include "TobiiSDK/Data/GazeFixation.hpp"
#include "TobiiSDK/Saliency.hpp"
#include "TobiiSDK/Stream/Project.hpp"
#include "TobiiSDK/Stream/InputVideoStream.hpp"
#include "TobiiSDK/Data/Recordings.hpp"
#include "TobiiSDK/Server/Interpolation.hpp"
#include "TobiiSDK/Server/GazeRecordings.hpp"

#define VIDEO_FILE_EXTENSION "avi"
#define SMI_DATA_FILE_EXTENSION "txt"
#define HEADER_DELIMINTER '#'
#define SEPARATOR "\t "
#define TIMESTAMP_COL_ID 0
#define POSX_COL_ID 2
#define POSY_COL_ID 3
#define FRAME_ID_COL_ID 4
#define DISTANCE 1450
namespace SMI
{
Tobii::GazeRecordings parseMe(std::string, int, int);
Tobii::Frame doSaliencyMap(Tobii::GazeFixation&, int, int);
Tobii::GazeFixation computeGazeFixation(std::vector<SMIData>&);
bool isFloat(const std::string);
bool checkExtension(std::string, std::string);
}
#endif
