#include "SMIDataParser.hpp"

namespace SMI
{
Tobii::GazeRecordings parseMe(std::string fileName, int vWidth, int vHeight)
{
  Tobii::GazeRecordings gazeRecordings;

  std::ifstream file(fileName);
  if(!file.is_open())
  {
    std::cerr << "Sorry we are not able to open " << fileName << std::endl
              << "Please be sure to enter a valid file name." << std::endl;
    return gazeRecordings;
  }

  std::string line;
  std::vector<SMIData> storage;

  while(std::getline(file, line))
  {
    if(line[0] != HEADER_DELIMINTER)
    {
      std::vector<std::string> vec;
      boost::split(vec, line, boost::is_any_of(SEPARATOR));
      SMIData data;
      bool isValidObject(false);
      int colId(0);
      for(auto& str : vec)
      {
        if(isFloat(str))
        {
          isValidObject = true;
          switch(colId)
          { 
            case POSX_COL_ID:
              if(std::stof(str) > vWidth)
                data.x(1);
              else if (std::stof(str) < 0)
                data.x(0);
              else
                data.x(std::stof(str) / vWidth);
              break;
            case POSY_COL_ID:
              if(std::stof(str) > vHeight)
                data.y(1);
              else if (std::stof(str) < 0)
                data.y(0);
              else
                data.y(std::stof(str) / vHeight);
              break;
            case FRAME_ID_COL_ID:
              data.frameId(std::stoi(str));
              break;
            default:
              break;
          }
          colId++;   
        }
      }
      if(isValidObject)
      {
        if(storage.size() != 0 && storage.back().frameId()!= data.frameId())
        {

          Tobii::GazeFixation gf(computeGazeFixation(storage));
          gazeRecordings.insert(gf);
          storage.clear();
        }
        storage.push_back(data);
        isValidObject = false;
      }
      vec.clear();
    }
  }
  if(storage.size() != 0)
  {
    Tobii::GazeFixation gf(computeGazeFixation(storage));
    gazeRecordings.insert(gf);
    storage.clear();
  }
  return gazeRecordings;
}

void addSyncData(Tobii::Frame& imgFrame, Tobii::Frame& saliencyFrame, Tobii::Project& project)
{
  Tobii::FramesMap framesMap;
  framesMap.emplace(Tobii::Project::Video, imgFrame);
  framesMap.emplace(Tobii::Project::Saliency, saliencyFrame);
  project.addFrames(framesMap);
}

Tobii::Frame doSaliencyMap(Tobii::GazeFixation& gf, int vWidth, int vHeight)
{
  cv::Size s(vWidth, vHeight);
  return Tobii::Saliency::computeSaliencyMap(gf, s);
}

Tobii::GazeFixation computeGazeFixation(std::vector<SMIData>& v)
{
  long int timestamp = (v.back().frameId()-1) * 40;
  float moyX(0);
  float moyY(0);
  int cpt(0);
  for(auto &data : v ){
    moyX += data.x();
    moyY += data.y();
    cpt++;
  }
  
  //std::cout << "Frame : " << v.back().frameId() << " fixation (x,y) : (" << (moyX/cpt)*1280 << "," << (moyY/cpt)*960 << ")" << std::endl;
  Tobii::Eye left;
  Tobii::Eye right;
  Tobii::Point2 p2(moyX/cpt, moyY/cpt);
  Tobii::Point3 p3;//(moyX/cpt, moyY/cpt, DISTANCE);
  Tobii::GazeFixation gf((Tobii::Int64)v.back().frameId(), 0); //, left, right, p2, p3); // TIMESTAMP AVANT
  gf.setPosition2D(p2); /*gf.setPosition3D(p3);*/gf.setDistance(DISTANCE);
  return gf;
}

bool checkExtension(std::string fileName, std::string ext)
{
  return fileName.substr(fileName.find_last_of(".") + 1) == ext;
}

bool isFloat(const std::string s)
{
  if(s.empty()
     || ((!isdigit(s[0])) && (s[0] != '-')
         && (s[0] != '+')))
    return false ; // is it a digit or a numeric sign ? No -> false
  
  char * p;
  strtof(s.c_str(), &p);
   
  return (*p == 0);
}
}