#include "AnnotationParser.hpp"

namespace SMI
{

std::string removeSpaces(std::string name)
{
  bool wasSpace = false;
  int nbBlank(0);
  for(int i = 0 ; i < name.length(); i++)
  {
    if(name[i] == ' ')
    {
      nbBlank++;
      wasSpace = true;
    }
    else
      if(nbBlank > 0)
      {
        if(wasSpace){ // if the previous char was a space, put this one in caps
          name[i] = toupper(name[i]);
          wasSpace = false;
        }
        name[i-nbBlank] = name[i];
      } 
  }
  while(nbBlank > 0){ // remove the duplicated chars
    name.pop_back();
    nbBlank--;
  }
  return name;
}

std::string extractOIName(std::string object){
  std::vector<std::string> split;
  boost::split(split, object, boost::is_any_of("(,)"));
  return removeSpaces(split[1]);
}


static unsigned long convertTime(std::string time)
{
  int h, m;
  float s;
  std::sscanf(time.c_str(), "%d:%d:%f", &h, &m, &s);
  return (h*3600 + m*60 + s)*1000;
}

Action parseAction(std::string line)
{     
  std::vector<std::string> tmp;
  boost::split(tmp, line, boost::is_any_of("\t"));
  int colId(0);
  Action action;

  for(auto &str : tmp)
  {
    switch(colId)
    {
      case ACTION_NAME_COL_ID:
        action.action(QString::fromStdString(str));
        break;    
      case START_TIME_COL_ID:
        action.startTime(convertTime(str));
        break;
      case END_TIME_COL_ID:
        action.endTime(convertTime(str));
        break;
      case OI_COL_ID:
        action.object(QString::fromStdString(extractOIName(str)));
        break;
      default:
        break;
    }
    colId++;
  }
  return action;
}
}


