#ifndef ACTION_HPP
#define ACTION_HPP

#include <QString>

namespace SMI
{

class Action {
public:
    QString             action() const               { return _action;         }
    void                action (QString action)      { _action = action;       }
    QString             object() const               { return _oi;             }
    void                object(QString object)       { _oi = object;           }
    unsigned long       startTime() const            { return _startTime;      }
    void                startTime(int startTime)     { _startTime = startTime; }
    unsigned long       endTime() const              { return _endTime;        }
    void                endTime(int endTime)         { _endTime = endTime;     }

    private:
    QString _action; // (take|mix|put|open...)
    QString _oi;     // object of interest
    unsigned long _startTime;  // in ms
    unsigned long _endTime;    // in ms

    public:
    bool operator<(const Action& a) const{
    return this->startTime() < a.startTime();
    }
};

}
#endif
