#include <QDir>
#include <QTextStream>

using String = char*;

int main ( int argc, String argv[] )
{
	QTextStream cout( stdout, QIODevice::WriteOnly );
	String dirName = argv[1];

	QDir directory( dirName );
	QFileInfoList contents = directory.entryInfoList(QStringList("*.png"));

	int timeStamp( 0 );

	cout << "Directory: " << dirName << " - " << contents.size() << " files" << endl;

	for ( const QFileInfo& fileInfo : contents )
	{
		QFile file( fileInfo.absoluteFilePath() );
		QString name = QString("%1/Frame_%2.png").arg( fileInfo.canonicalPath() ).arg(timeStamp);

		cout << file.fileName() << " -> " << name << endl;
		file.rename( name );
		timeStamp += 40;
	}
}