#ifndef LIVEHEATMAPAPP_HPP
#define LIVEHEATMAPAPP_HPP

#include "TobiiSDK/FileApplication.hpp"
#include "TobiiSDK/Saliency.hpp"

using namespace Tobii;

class LiveWeightedMapApp : public FileApplication
{
	Q_OBJECT
private:
	Frame _saliencyMap, _weightedMap;

public:
	LiveWeightedMapApp ( const int argc, const char* argv[] );
	
	const Frame&	saliencyMap	() const;
	Frame&			saliencyMap	();
	const Frame&	weightedMap	() const;
	Frame&			weightedMap	();

	virtual int run ();

public slots:
	virtual void receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

private:
	LiveWeightedMapApp ( const LiveWeightedMapApp& );
	LiveWeightedMapApp& operator= ( const LiveWeightedMapApp& );
};

#endif // LIVEHEATMAPAPP_HPP