#ifndef LIVESALIENCYMAPGPUAPP_HPP
#define LIVESALIENCYMAPGPUAPP_HPP

#include "TobiiSDK/FileApplication.hpp"
#include "TobiiSDK/Saliency.hpp"

using namespace Tobii;

class LiveSaliencyMapGPUApp : public FileApplication
{
	Q_OBJECT
private:
	Frame _saliencyMap, _heatMap;

public:
	LiveSaliencyMapGPUApp ( const int argc, const char* argv[] );
	
	const Frame&	saliencyMap	() const;
	Frame&			saliencyMap	();

	virtual int run ();

public slots:
	virtual void receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

private:
	LiveSaliencyMapGPUApp ( const LiveSaliencyMapGPUApp& );
	LiveSaliencyMapGPUApp& operator= ( const LiveSaliencyMapGPUApp& );
};

#endif // LIVESALIENCYMAPGPUAPP_HPP