#ifndef LIVESALIENCYMAPAPP_CPP
#define LIVESALIENCYMAPAPP_CPP

#include "LiveSaliencyMapApp.hpp"

LiveSaliencyMapApp::LiveSaliencyMapApp ( const int argc, const char* argv[] )
: FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

const Frame&	LiveSaliencyMapApp::saliencyMap	() const	{ return this->_saliencyMap;	}
Frame&			LiveSaliencyMapApp::saliencyMap	()			{ return this->_saliencyMap;	}

int LiveSaliencyMapApp::run ()
{
	// Open the files
	this->FileApplication::run();

	// Main Loop
	while ( !this->hasFinished() )
	{
		this->mutex().lock();

		if ( this->saliencyMap().cols > 0 && this->saliencyMap().rows > 0 )
			this->displayFrame( this->saliencyMap() );

		this->mutex().unlock();
	}
	return EXIT_SUCCESS;
}

void LiveSaliencyMapApp::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
{
	this->mutex().lock();
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	if ( ptrFrame && ptrFixation )
	{
		// Compute saliency
		this->saliencyMap() = Saliency::computeSaliencyMap( *this->ptrFixation(), this->ptrFrame()->size() );

		// Record in the output video / dump (if option is set)
		cv::cvtColor( this->saliencyMap(), this->saliencyMap(), CV_GRAY2RGB ); // cv::imwrite needs Mat of type CV_8UC3
		
		this->recordFrame( this->saliencyMap() );
		this->dumpFrame( this->saliencyMap(), ptrFrame->timeStamp() );
	}

	this->mutex().unlock();
}

#endif // LIVESALIENCYMAPAPP_CPP