#ifndef LIVEHEATMAPGPUAPP_HPP
#define LIVEHEATMAPGPUAPP_HPP

#include "TobiiSDK/FileApplication.hpp"
#include "TobiiSDK/Saliency.hpp"

using namespace Tobii;

class LiveHeatMapGPUApp : public FileApplication
{
	Q_OBJECT
private:
	Frame _saliencyMap, _heatMap;

public:
	LiveHeatMapGPUApp ( const int argc, const char* argv[] );
	
	const Frame&	saliencyMap	() const;
	Frame&			saliencyMap	();
	const Frame&	heatMap		() const;
	Frame&		heatMap		();

	virtual int run ();

public slots:
	virtual void receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation );

private:
	LiveHeatMapGPUApp ( const LiveHeatMapGPUApp& );
	LiveHeatMapGPUApp& operator= ( const LiveHeatMapGPUApp& );
};

#endif // LIVEHEATMAPGPUAPP_HPP